/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-14,Chemical and Phase Equilibrium
//Example 14_6 Page:571
//Title:Determining the Equilibrium Flame Temperature
//===============================
model Ex14_6
  //parameter selection
  parameter Real pref(unit = "atm") = 1 "reference pressure";
  parameter Real p(unit = "atm") = 1 "mixture pressure";
  parameter Real K(unit = "-") = 0.020941 "equilibrium constant";      
                                    /*From Table A-27 value of K at T=2399 K. 
                                    After solving iteratively. 
                                    Appendix Pg:A-48*/
  //===============================
  
  //variable selection
  Real z(unit = "-") "stoichiometric coefficient";
  Real yCO(unit = "-") "equilibrium composition of CO";
  Real yCO2(unit = "-") "equilibrium composition of CO2";
  Real yO2(unit = "-") "equilibrium composition of O2";
  Real yN2(unit = "-") "equilibrium composition of N2";
  
  //===============================
  
  //equation selection
  equation
    K = z / (1 - z) * (z /( 5.76 + z ) ) ^ (1 / 2) * (p / pref) ^ (1 / 2);  //Equilibrium constant
                                                                            //From Eq.14.35, Pg:565
    yCO = z;
    yCO2 = (1 - z);
    yN2 = 1.88;
    yO2 = z / 2 ;                                     //Composition of mixture from reaction equation

/*When solved iteratively using tabular data,the results are z = 0.125 and T = 2399 K*/
end Ex14_6;
