/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-14,Chemical and Phase Equilibrium
//Example 14_8 Page:575
//Title:Considering Ionization Equilibrium
//===============================
model Ex14_8
 
 //parameter selection
  parameter Real pref(unit = "atm") = 1 "reference pressure";
  parameter Real K(unit = "-") = 15.63 "equilibrium constant"; 
  parameter Real z(unit="-")=0.95 "extent of ionization";
  //===============================
  
  //variable selection
  Real p(unit = "atm") "mixture pressure";
  //===============================

  //equation selection
  equation
   K = (z)^2 / (1 - (z)^2) * (p / pref);  //Equilibrium constant
                                          //From Eq.14.35, Pg:565
end Ex14_8;
//===============================
