/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-2 Energy and the First Law of Thermodynamics
//Example 2_5 Page:48
//Title:Silicon Chip at Steady State
//===============================
model Ex2_5

  //parameter selection
  parameter Real a(unit="mm")=5"Side of the silicon chip";
  parameter Real W(unit="W")=-0.225"Power input";
  parameter Real Tf(unit="C")=20"Coolant temperature";
  parameter Real h(unit="W/m2.K")=150"Heat transfer coefficient";
  //===============================
   
  //variable selection
  Real Q(unit="W")"Heat transfer rate";
  Real Tb(unit="K")"Surface temperature of chip";
  Real A(unit="m2")"Area of the silicon chip";
  //===============================
    
  //equation selection
  equation
    A=(a/10^3)^2;              //Dividing by 10^3 to convert into m
    Q=-h*A*(Tb-(Tf+273.15));   //Energy transfer rate 
                               //Adding 273.15 to convert into Kelvin scale
    Q=W;

end Ex2_5;
  //===============================
