/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-3 Evaluating properties
//Example 3_1 Page:67
//Title:Heating ammonia at constant pressure
//===============================
  package Ex3_1
  //===============================
    model Ex3_1_a
    //To find volume occupied
  
    //parameter selection
    parameter Real m(unit = "lb") = 0.1 "mass of ammonia";
    parameter Real P(unit = "lbf/in2") = 20 "pressure of the ammonia";
    parameter Real T2(unit = "F") = 77 "final temperature";
    parameter Real v1(unit = "ft3/lb") = 13.497 "specific volume at state 1";    
                                                              /*At P=20lbf/in^2 and saturation                                                          
                                                              temperature from Table A-15E.
                                                              Appendix Pg-A-77 */  
    parameter Real v2(unit = "ft3/lb") = 16.7 "specific volume at state 2";      
                                                              /*At P=20lbf/in^2 and T= 77 F
                                                              from Table A-15E. 
                                                              Appendix Pg-A-77 */
                                                                      
    //===============================
    
    //variable selection
    Real V1(unit = "ft3") "volume occupied by ammonia at state 1";
    Real V2(unit = "ft3") "volume occupied by ammonia at state 2";
    //===============================
    
    //equation selection
    equation
      V1 = m * v1;
      V2 = m * v2;
      
   end Ex3_1_a;

  //===============================

   model Ex3_1_b 
   //To find work

    //===============================
    extends Ex3_1_a;
    //===============================
    
    //varible selection
    Real W(unit="Btu")"Work";
    //===============================
    
    //equation selection
    equation
      W=P*(V2-V1)*(144/778);  //Work expression
                              //Multiplying by (144/778) to convert into Btu
                          
   end Ex3_1_b;

//===============================
end Ex3_1;
//===============================
