/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-3 Evaluating properties
//Example 3_10 Page:97
//Title:Using the Energy Balance and Constant Specific Heats
//===============================
package Ex3_10
  //===============================
  model Ex3_10_a
  //To find the final pressure
    //===============================
    //parameter selection
    parameter Real m1(unit = "kg") = 2 "mass of gas in tank 1";
    parameter Real m2(unit = "kg") = 8 "mass of gas in tank 2";
    parameter Real T1(unit = "C") = 77 "temperature of gas in tank 1";
    parameter Real T2(unit = "C") = 27 "temperature of gas in tank 2";
    parameter Real Tf(unit = "C") = 42 "final equilibrium temperature";
    parameter Real P1(unit = "bar") = 0.7 "pressure of gas in tank 1";
    parameter Real P2(unit = "bar") = 1.2 "pressure of gas in tank 2";
    parameter Real R(unit = "kJ/kmol.K") = 8.314"gas constant";
    //===============================
    
    //variable selection
    Real Pf(unit = "bar") "final equlibrium pressure";
    Real V1(unit = "m3") "volume in tank 1";
    Real V2(unit = "m3") "volume in tank 2";
    //===============================
    
    //equation selection
    equation
      V1 = m1 * (T1 + 273.15) / P1;
      V2 = m2 * (T2 + 273.15) / P2;
      Pf = (m1 + m2) * (Tf + 273.15) / (V1 + V2);     //Reduced ideal gas equation. From Example 3.10(a) Pg:98
  end Ex3_10_a;
  //===============================

  model Ex3_10_b
  //To find the heat transfer for the process
  
    //===============================  
    extends Ex3_10_a;
    //===============================
    
    //parameter selection
    parameter Real cv(unit="kJ/kg")=0.745"specific heat";   
                                              /*For T=300 K and 350 K. From Table A-20. 
                                              Appendix Pg:A-37*/
    //===============================
    
    //variable selection  
    Real Q(unit="kJ")"heat transfer for the process";
    //===============================
    
    //equation selection
    equation
      Q=m1*cv*(Tf-T1)+m2*cv*(Tf-T2);          //Energy balance equation with specific heat term
  end Ex3_10_b;
  //===============================
end Ex3_10;
//===============================
