/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-3 Evaluating properties
//Example 3_2 Page:71
//Title:Heating water at constant volume
//===============================
package Ex3_2

  model Ex3_2_a
  //To find temperature
    //parameter selection
    parameter Real V(unit = "m3") = 0.5 "volume of container";
    parameter Real p1(unit = "bar") = 1 "pressure at state 1";
    parameter Real p2(unit = "bar") = 1.5 "pressure at state 2";
    parameter Real x1(unit = "-") = 0.5 "quality of vapour at state 1";
    parameter Real vf1(unit = "m3/kg") = 1.0432e-3 "specific volume of saturated liquid at state 1";
    parameter Real vg1(unit = "m3/kg") = 1.694 "specific volume of saturated vapour at state 1";
    parameter Real vf2(unit = "m3/kg") = 1.0582e-3 "specific volume of saturated liquid at state 2";
    parameter Real vg2(unit = "m3/kg") = 1.159 "specific volume of saturated vapour at state 2";
                                                                           /*From Table A-3 at p=1 bar
                                                                           Appendix Pg:A-5*/
    //===============================
    
    //variable selction
    Real v1(unit = "m3/kg") "specific volume at state 1";
    Real v2(unit = "m3/kg") "specific volume at state 2";
    //===============================
    
    //equation selection
   equation
    v1 = vf1 + x1 * (vg1 - vf1);      //Specific volume for two phase liquid-vapour mixture
    v1 = v2;                          //Constant volume
    
    
/*As v1=v2(constant volume) the corresponding saturation temperature can be obtained from Table A-3(Appendix Pg:A-5) for respective pressure values*/
//T1=99.63 C;T2=111.4 C
  end Ex3_2_a;

  //===============================

  model Ex3_2_b
  //To find mass of vapour
       //===============================
      extends Ex3_2_a;
       //===============================
       
       //variable selection
      Real m(unit="kg")"total mass";
      Real x2(unit="-")"quality of vapour at state 2";
      Real mg1(unit="kg")"mass of vapour at state 1";
      Real mg2(unit="kg")"mass of vapour at state 2";
      //===============================
       
      //equation selection
      equation
      m=V/v2;                 //Total mass
      x2=(v2-vf2)/(vg2-vf2);  //Vapour quality of liquid-vapour mixture
      mg1=x1*m;               
      mg2=x2*m;               //Mass of vapour at corresponding state
      
  end Ex3_2_b;

  //===============================

  model Ex3_2_c
  //To find pressure
  
      //parameter selection
      parameter Real vg(unit="m3/kg")=0.8475"specific volume at state 3";
      parameter Real v1(unit="m3/kg")=0.8857"specific volume 1";
      parameter Real v2(unit="m3/kg")=0.7187"specific volume 2";
      parameter Real p1(unit="bar")=2.0"saturation pressure 1";
      parameter Real p2(unit="bar")=2.50"saturation pressure 2";       
                                                /*From Table A-3 for corresponding 
                                                specific volume vg=0.8475 m^3/kg. 
                                                Appendix Pg:A-5*/
      //===============================
      
      //variable selection
      Real p3(unit="bar")"pressure at state 3";
      //===============================
      
      //equation selection
      equation
        (vg-v1)/(v2-v1)=(p3-p1)/(p2-p1);          //Interpolation
  end Ex3_2_c;
  //===============================
end Ex3_2;
