/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-3 Evaluating properties
//Example 3_3 Page:77
//Title:Stirring water at constant volume
//===============================
model Ex3_3

  //parameter selection
  parameter Real V(unit="ft3")=10"volume of tank";
  parameter Real T1(unit="F")=212"initial temperature";
  parameter Real p2(unit="lbf/in2")=20"final pressure";
  parameter Real v1(unit="ft3/lb")=26.80"specific volume";            /*At T=212 F from Table A-2E. 
                                                                      Appendix Pg:A-52*/
                                                                      
  parameter Real u1(unit="Btu/lb")=1077.6"initial internal energy";   /*At T=212 F from Table A-2E. 
                                                                      Appendix Pg:A-52*/
                                                                      
  parameter Real T2(unit="F")=445"final temperature";                 /*By using υ2 = υ1 and 
                                                                      interpolating in Table A-4E at 
                                                                      p=20 lbf/in^2 . Appendix Pg:A-55*/
  parameter Real u2(unit="Btu/lb")=1161.6"final internal energy";     /*By using υ2 = υ1 and interpolating in
                                                                       Table A-4E at p=20 lbf/in^2 . 
                                                                       Appendix Pg:A-55*/                                                                      
                                                                      
                                                                      
                                                                      
  //===============================
   
  //variable selection
  Real W(unit="Btu")"energy transfer by work";
  Real m(unit="lb")"system mass";
  //===============================
  
  //equaion selection
  equation
    W=-m*(u2-u1);    //Energy balance equation
    m=V/v1;

end Ex3_3;
//===============================
