/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-3 Evaluating properties
//Example 3_4 Page:78
//Title:Analysing two process in series
//===============================
package Ex3_4
  model Ex3_4_b
    //Work for overall process
    
    //parameter selection
    parameter Real p(unit = "bar") = 10 "initial prssure";
    parameter Real T1(unit = "C") = 400 "initial temperature";
    parameter Real v1(unit = "m3/kg") = 0.3066 "specific volume at state 1";        
                                                        /*At P=10bar and T=400 C, from
                                                        Table A-4. Appendix Pg:A-8*/   
    parameter Real u1(unit = "kJ/kg") = 2957.3 "specific internal energy at state 1";
                                                        /*At P=10bar and T=400 C,
                                                        Table A-4.Appendix Pg:A-8*/                                                                                   
    parameter Real v2(unit = "m3/kg") = 0.1944 "specific volume at state 2";         
                                                        /*At P=10bar and T=saturated
                                                        temperature,from Table A-3. 
                                                        Appendix Pg:A-5*/
    //===============================
    
    //variable selection
    Real W_m(unit = "kJ/kg") "work for overall process";
    //===============================
    
    //equation selection
  equation
    W_m = p * (v2 - v1) * (10 ^ 5 / 10 ^ 3);  //Work expression
                                            //Multiplying by 10^5 to convert into Pa
                                            //Dividing by 10^3 to convert into kJ
  end Ex3_4_b;

  //===============================

  model Ex3_4_c
    //Heat transfer for overall process
    
    //===============================
    extends Ex3_4_b;
    //===============================
    
    //parameter selection
    parameter Real v2(unit = "m3/kg") = 0.1944 "specific volume at state 2";    
                                                          /*At P=10 bar and T=400 C,                                                                                           
                                                          from Table A-4. 
                                                          Appendix Pg:A-8*/                                                                                                  
    parameter Real vf3(unit = "m3/kg") = 1.0905e-3 "specific volume of pure liquid at state 3";
    parameter Real vg3(unit = "m3/kg") = 0.3928 "specific volume of pure vapour at state 3";
    parameter Real uf3(unit = "kJ/kg") = 631.68 "specific internal energy of pure liquid at state 3";
    parameter Real ug3(unit = "kJ/kg") = 2559.5 "specific internal energy of pure vapour at state 3";
                                                          /*From Table A-2 at
                                                          T=150 C.Appendix Pg:A-4*/
    //===============================
    
    //variable selection
    Real x3(unit = "-") "quality of vapour at state 3";
    Real Q_m(unit = "kJ/kg") "heat transfer";
    Real v3(unit = "m3/kg") "specific volume at state 3";
    Real u3(unit = "kJ/kg") "specific internal energy at state 2";
    //===============================
    
    //equation selction
    equation
      x3 = (v3 - vf3) / (vg3 - vf3);      //Vapour quality for liquid-vapour mixture
      v2 = v3;
      u3 = uf3 + x3 * (ug3 - uf3);        //Total specific internal energy
      Q_m = u3 - u1 + W_m;                //Energy balance for overall equation
  end Ex3_4_c;

  //===============================
end Ex3_4;
