/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-3 Evaluating properties
//Example 3_7 Page:88
//Title:Using the generalized compressibility chart
//===============================
package Ex3_7
//===============================
  model Ex3_7_a
  //To find specific volume at initial state
    
    //parameter selection
    parameter Real M(unit = "kg/kmol") = 18.02 "molecular weight of water";   
                                                      /*From Table A-1.Appendix Pg:A-2*/
    parameter Real P1(unit = "MPa") = 20 "initial pressure";
    parameter Real T1(unit = "C") = 520 "initial temperature";
    parameter Real T2(unit = "C") = 400 "final temperature";
    parameter Real Tc(unit = "K") = 647.3 "critical temperature";     
    parameter Real Pc(unit = "MPa") = 22.09 "critical pressure";      
                                                      /*From Table A-1.Appendix Pg:A-2*/
    parameter Real R(unit = "N.m/kmol.K") = 8314 "gas constant";
    parameter Real Z(unit = "-") = 0.83 "compressibility factor";     
                                                      /*From Fig,A-1For values Tr1 and Pr1. 
                                                      Appendix Pg:A-97*/
    //===============================
     
    //variable selection
    Real v(unit = "m3/kg") "specific volume at initial state";
    Real Tr1(unit = "-") "reduced temperature at state 1";
    Real Pr1(unit = "-") "reduced pressure at state 1";
    //===============================
    
    //equation selection
    equation
      v = Z * R * (T1 + 273.15) / (M * P1 * 10 ^ 6);    //Compressibility factor equation
      Tr1 = (T1 + 273.15) / Tc;                         //Reduced Temperature
                                                        //Adding 273.15 to convert in Kelvin scale
      Pr1 = P1 / Pc;                                    //Reduced Pressure
  end Ex3_7_a;
   //===============================

  model Ex3_7_b
  //To find the pressure at final state
    
    //===============================
    extends Ex3_7_a;
    //===============================
    
    //parameter selection
    parameter Real Pr2(unit"-")=0.69"reduced pressure at state 2";  
                                                    /*From compressibility chart for 
                                                    vr=1.12 and Tr=1.04*/                               
    //===============================
    
    //variable selection
    Real vr(unit"-")"reduced volume";
    Real Tr2(unit"-")"reduced temperature at state 2";
    Real P2(unit="MPa")"pressure at state 2";
    //===============================
    
    //equation selection
    equation
      vr=(v*Pc*10^6)/(R/M*Tc);//Reduced volume
                              //Multiplying 10^6 to convert into Pa
      Tr2=(T2+273.15)/Tc;     //Reduced temperature
                              //Adding 273.15 to convert in Kelvin scale
      P2=Pc*Pr2;              //Reduced pressure

  end Ex3_7_b;
   //===============================
end Ex3_7;
