/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-3 Evaluating properties
//Example 3_8 Page:91
//Title:Analyzing Air as an Ideal Gas Undergoing a Thermodynamic Cycle
//===============================
package Ex3_8
 //===============================
  model Ex3_8_b
  //To find temperature at state 2
  
    //parameter selection
    parameter Real T1(unit = "R") = 540 "temperature at state 1";
    parameter Real P1(unit = "atm") = 1 "pressure at state 1";
    parameter Real P2(unit = "atm") = 2 "pressure at state 2";
    //===============================
    
    //variable selection
    Real T2(unit = "R") "temperature at state 2";
     //===============================
     
     //equation selection
    equation
      T2 = P2 * T1 / P1;           //Pressure-Temperature relation
    end Ex3_8_b;
  //===============================

  model Ex3_8_c
  //To find specific volume at state 3
  
   //===============================
   extends Ex3_8_b;
   //===============================
  
    //parameter selection
    parameter Real R(unit="ft.lbf/lbmol.R")=1545"gas constant";
    parameter Real M(unit="lb/lbmol")=28.97"molecular weight of air";    
                                              /*From Table A-1E.Appendix Pg:A-50*/
     //===============================
     
     //variable selection
    Real v3(unit="ft3/lb")"specific volume at state 3";
     //===============================
      
    //equation selection
    equation
    v3=(R*T2)/(M*P1)/(14.7*144);            //Dividing by (14.7*144) to convert atm to lbf/ft^2
    
  end Ex3_8_c;
   //===============================
end Ex3_8;
