/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-3 Evaluating properties
//Example 3_9 Page:96
//Title:Using the Energy Balance and Ideal Gas Tables
//===============================
model Ex3_9

   //parameter selection
   parameter Real m(unit="lb")=2"mass of air";
   parameter Real T1(unit="R")=540"temperature at state 1";
   parameter Real P1(unit="atm")=1"pressure at state 1";
   parameter Real T2(unit="R")=840"temperature at state 2";
   parameter Real P2(unit="atm")=6"pressure at state 2";
   parameter Real Q(unit="Btu")=-20"heat transfer";
   parameter Real u1(unit="Btu/lb")=92.04"specific internal energy at state 1";     
                                                            /*From Table A-22E at T=540 R.
                                                            Appendix Pg:A-89*/
   parameter Real u2(unit="Btu/lb")=143.98"specific internal energy at state 2";    
                                                            /*From Table A-22E at T=840 R. 
                                                            Appendix Pg:A-89*/
   //===============================
    
   //variable selection
   Real W(unit="Btu")"work during the process";
   //===============================
    
   //equation selection    
   equation
    W=Q-m*(u2-u1);           //Energy balance equation
    
end Ex3_9;
