/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-4,Control Volume Analysis Using Energy
//Example 4_11 Page:136
//Title:Evaluating Heat Transfer for a Partially Emptying Tank
//===============================
model Ex4_11
    
    //parameter selection
    parameter Real V(unit="m3")=0.85"volume of the tank";
    parameter Real x1(unit="-")=0.7"quality of vapour";
    parameter Real uf1(unit="kJ/kg")=1128.4"initial specific internal energy of saturated liquid";                                                          
    parameter Real ug1(unit="kJ/kg")=2599.0"initial specific internal energy of saturated vapour";
    parameter Real vf1(unit="m3/kg")=1.2755e-3 "initial specific volume of saturated liquid"; 
    parameter Real vg1(unit="m3/kg")=0.04221"initial specific volume of saturated vapour";
    parameter Real he(unit="kJ/kg")=2796.6"specific enthalpy of saturated vapour";
                                                              /*From Table A-2 at T=260 C.
                                                               Appendix Pg:A-4*/
    parameter Real u2(unit="kJ/kg")=2599.0"final specific internal energy";
    parameter Real v2(unit="m3/kg")=42.21e-3"final specific volume";
    //===============================
                                                            
    //varible selection                                                           
    Real u1(unit="kJ/kg")"initial specific internal energy";
    Real v1(unit="m3/kg")"initial specific volume";
    Real m1(unit="kg")"initial mass of vapour";
    Real m2(unit="kg")"final mass of vapour";
    Real Qcv(unit="kJ")"amount of heat transfer";
    //===============================
    
    //equation selection
    equation
      u1=uf1+x1*(ug1-uf1);            //Specific internal energy for liquid-vapour mixture
      v1=vf1+x1*(vg1-vf1);            //Specific volume for liquid-vapour mixture
      m1=V/v1;
      m2=V/v2;                        
      Qcv=(m2*u2-m1*u1)-he*(m2-m1);   //Reduced energy balance equation

end Ex4_11;
//===============================
