/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-4,Control Volume Analysis Using Energy
//Example 4_14 Page:141
//Title:Determining Temperature-Time Variation in a Well-Stirred Tank
//===============================
model Ex4_14

    //parameter selection
    parameter Real T1(unit="C")=45"temperature of inlet water";
    parameter Real m(unit="kg/h")=270"mass flow rate of water";
    parameter Real mcv(unit="kg")=45"water in tank";
    parameter Real Wcv(unit="kW")=-0.6"power input to the water";
    parameter Real Qcv(unit="kW")=-7.6"heat transfer to tank";
    final constant Real c(final unit="kJ/kg.K")=4.2"specific heat of water";  /*From Table A-9. 
                                                                              Appendix Pg:A-36*/
    //===============================
    
    //===============================
    
    annotation(experiment(StartTime = 0, StopTime =4000));  //Time range selection for graph
    //===============================
    
    //variable selection
    Real T(unit="C")"temperature of the tank";
    //===============================
    
    //equation selection
    equation
      T=(T1+273.15)+((Qcv-Wcv)/(m*c/3600))*(1-exp(-m*time/(mcv*3600)));  
                                                  //From Ex 4.14 Pg:142
                                                  //Adding 273.15 to convert in Kelvin scale
                                                  //Dividing by 3600 to convert into hour

end Ex4_14;
//Final answer is plotted as graph
//===============================
