/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-4,Control Volume Analysis Using Energy
//Example 4_2 Page:110
//Title:Applying the Mass Rate Balance to a Barrel Filling with Water
//===============================
model Ex4_2
    
    //parameter selection
    parameter Real mi(unit="lb/s")=30"inlet mass flow rate";
    parameter Real A(unit="ft2")=3"area of the base";
    parameter Real rho(unit="lb/ft3")=62.4"density of water";
    //===============================
    
    //===============================
    annotation(experiment(StartTime = 0, StopTime =120));               //Time range selection for graph
    //===============================
    
    //variable selection
    Real mcv(unit="lb")"mass of water contained at time t";
    Real L(unit="ft")"instantaneous liquid height";
    Real me(unit="lb/s")"exit mass flow rate";
     //===============================
    
    //equation selection
    equation
    me=9*L;                        //Given 
    mcv=rho*A*L;                   //Mass of water
    der(mcv)=mi-me;                //From Eq.4.2, Pg:106

end Ex4_2;
//Final answer is plotted as graph
//===============================
