/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-4,Control Volume Analysis Using Energy
//Example 4_3 Page:118
//Title:Calculating Exit Area of a Steam Nozzle
//===============================
model Ex4_3

    //parameter selection
    parameter Real p1(unit="bar")=40"inlet steam pressure";
    parameter Real T1(unit="C")=400"inlet steam temperature";
    parameter Real V1(unit="m/s")=10"inlet steam velocity";
    parameter Real p2(unit="bar")=15"exit steam pressure";
    parameter Real V2(unit="m/s")=665"exit steam velocity";
    parameter Real m(unit="kg/s")=2"exit mass flow rate";
    parameter Real h1(unit="kJ/kg")=3213.6"specific enthalpy at inlet";      
                                                        /*From Table A-4 at P=40 bar and T=400 C. 
                                                        Appendix Pg:A-9*/
    parameter Real v2(unit="m3/kg")=0.1627"specific volume at exit";         
                                                        /*From Table A-4 at P=15 bar with 
                                                        h2=2992.5 kJ/kg. Appendix Pg:A-8*/
    parameter Real Qcv(unit="kJ/s")=0"heat transfer";
    parameter Real Wcv(unit="kJ/s")=0"net power"; 
    //===============================
    
    //variable selection
    Real A2(unit="m2")"exit area of nozzle";
    Real h2(unit="kJ/kg")"specific enthalpy at exit";
    //===============================
    
    //equation selection
    equation
    A2=m*v2/V2;                                    //From Eq.4.4b, Pg:108
    0=Qcv-Wcv+m*((h1-h2)+((V1^2-V2^2)/2)/10^3);    //Steady-state energy rate balance equation
                                                   //Dividing by 10^3 to convert bar into Pa
end Ex4_3;
//===============================
