/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-4,Control Volume Analysis Using Energy
//Example 4_5 Page:123
//Title:Calculating Compressor Power
//===============================
model Ex4_5

    //parameter selection
    parameter Real p1(unit="bar")=1"inlet air pressure";
    parameter Real T1(unit="K")=290"inlet air temperature";
    parameter Real V1(unit="m/s")=6"inlet air velocity";
    parameter Real A1(unit="m2")=0.1"inlet area";
    parameter Real p2(unit="bar")=7"exit air pressure";
    parameter Real T2(unit="K")=450"exit air temperature";
    parameter Real V2(unit="m/s")=2"exit air velocity";
    parameter Real Qcv(unit="kJ/min")=-180"heat transfer";
    parameter Real h1(unit="kJ/kg")=290.16"specific enthalpy at inlet";       
                                                    /*From Table A-22 for T=290 K. 
                                                    Appendix Pg:A-39*/
    parameter Real h2(unit="kJ/kg")=451.8"specific enthalpy at exit";         
                                                    /*From Table A-22 for T=450 K.
                                                    Appendix Pg:A-40*/
    final constant Real R(final unit="J/kmol.K")=8314"gas constant";
    final constant Real M(final unit="kg/kmol")=28.97"molecular mass of air"; 
                                                    /*From Table A-1. Appendix Pg:A-2*/
    //===============================
    
    //variable selection
    Real Wcv(unit="kW")"power input";
    Real m(unit="kg/s")"mass flow rate";
    Real v1(unit="m3/kg")"specific volume at inlet";
    //===============================
    
    //equation selection 
    equation
    v1=R*T1/(M*p1*10^5);                                //Ideal gas equation
                                                        //Multiplying by 10^5 to convert bar into Pa
    m=A1*V1/v1;                                         //Mass flow rate
    0=(Qcv/60)-Wcv+m*((h1-h2)+((V1^2-V2^2)/2)/10^3);    //Steady-state energy rate balance equation
                                                        //Dividing by 10^3 to convert Pa into kPa 
                                                        //Dividing by 60 to convert s to min 

end Ex4_5;
//===============================
