/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-4,Control Volume Analysis Using Energy
//Example 4_6 Page:123
//Title:Analyzing a Pump System
//===============================
package Ex4_6
  model Ex4_6_a
    //To find velocity of water at inlet and exit
    
    //===============================
    extends Modelica.Constants;
    //===============================
    
    //parameter selection
    parameter Real AV1(unit = "gal/min") = 220 "volumetric flow rate";
    parameter Real D1(unit = "in") = 5 "inlet diameter";
    parameter Real D2(unit = "in") = 1 "nozzle exit diameter";
    parameter Real T1(unit = "F") = 70 "inlet temperature";
    parameter Real p1(unit = "lbf/in2") = 14.7 "inlet pressure";
    parameter Real z1(unit = "ft") = 0 "height of inlet";
    parameter Real z2(unit = "ft") = 35 "elevation from the inlet";
    parameter Real v(unit = "ft3/lb") = 0.01605 "specific volume of water";        
                                                              /*From Table A-2E at T=70 F. 
                                                              Appendix Pg:A-51*/
    final constant Real gc(final unit = "ft/s2") = 32.2 "accleration due to gravity";
    //===============================
    
    //variable selection
    Real V1(unit = "ft/s") "inlet velocity";
    Real V2(unit "ft/s") "exit velocity";
    Real m(unit = "lb/s") "mass flow rate";
    //===============================
    
    //equation selection
    equation
    m = AV1 / v * (0.13368 / 60);                  //Mass flow rate
                                                   //Multiplying by (0.13368/60) to convert into lb/s
    V1 = m * v / (pi * D1 ^ 2 / 4) * 144;          //Velocity expression
    V2 = m * v / (pi * D2 ^ 2 / 4) * 144;          //Multiplying by 144 to convert ft^2 into in^2
  end Ex4_6_a;

  //===============================

  model Ex4_6_b
  //To find the power required
  
      //===============================
      extends Ex4_6_a;
      //===============================
      
      //parameter selection
      parameter Real x(unit = "-") = 0.05 "magnitude of heat transfer of the power input";
      //===============================
      
      //variable selection
      Real Qcv(unit = "Btu/lb") "heat transfer rate";
      Real dKE(unit = "Btu/lb") "change in kinetic energy";
      Real dPE(unit = "Btu/lb") "change in potential energy";
      Real Wcv(unit = "Btu/lb") "power required by the pump";
      Real Wcv2(unit = "hp") "power required by the pump in hp";
      //===============================
      
      //equation selection
      equation
      Qcv = x * Wcv;
      dKE = (V1 ^ 2 - V2 ^ 2) / 2 * 1 / (778 * 32.174);  //Change in kinetic energy
      dPE = gc * (z1 - z2) * 1 / (778 * 32.174);         //Change in potential energy
                                                         //Dividing by (778*32.174) to convert into Btu/lb
      Wcv - Qcv = m * (dKE + dPE);                       //Steady-state energy balance equation
      Wcv2=Wcv*(3600/2545);                              //Multiplying by(3600/2545)to convert into hp
  end Ex4_6_b;
  //===============================
  //===============================
end Ex4_6;
