/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-4,Control Volume Analysis Using Energy
//Example 4_8 Page:129
//Title:Cooling Computer Components
//===============================
model Ex4_8

    //parameter selection
    parameter Real T1(unit="C")=20"inlet temperature";
    parameter Real p1(unit="atm")=1"inlet pressure";
    parameter Real V1(unit="m/s")=1.3"maximum inlet velocity";
    parameter Real T2(unit="C")=32"maximum exit temperature";
    parameter Real Qcv(unit="J/s")=0"heat transfer rate";
    parameter Real cp(unit="kJ/kg.K")=1.005"specific heat of air";
    parameter Real Wcve(unit="W")=-80"electric power received by electronic component";
    parameter Real Wcvf(unit="W")=-18"electric power received by fan";
    final constant Real R(final unit="J/kmol.K")=8314"gas constant";
    final constant Real M(final unit="kg/kmol")=28.97"molecular mass of air"; 
                                                  /*From Table A-1. Appendix Pg:A-2*/

    //===============================
    
    //variable selection
    Real A1(unit="cm2")"smallest fan inlet area";
    Real v1(unit="m3/kg")"specific volume of air at inlet";
    Real m(unit="kg/s")"mass flow rate";
    Real Wcv(unit="W")"total electric power";
    //===============================
    
    //equation selection
    equation
      A1=m*v1/V1*10^4;                      //Continuity equation
                                            //Multiplying by 10^4 to convert into cm^2
      v1=R*(T1+273.15)/(M*p1*1.01325*10^5); //Ideal gas equation
                                            //Adding 273.15 to convert in Kelvin scale
                                            //Multiplying by 1.01325e5 to convert into Pa
      Wcv=Wcve+Wcvf;                        
      Qcv-Wcv=m*cp*(T2-T1)*10^3;            //Energy balance equation 
                                            //Multiplying 10^3 to convert into J

end Ex4_8;
//===============================
