/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-5,The second law of thermodynamics
//Example 5_1 Page:168
//Title:Evaluating power cycle performance
//===============================
package Ex5_1
//===============================
  model Ex5_1_a
  //Given Qh=1000kJ, efficiency=0.6
  //===============================
  //parameter selection
  
    parameter Real Th(unit = "K") = 2000 "Hot reservoir temperature";
    parameter Real Tc(unit = "K") = 400 "Cold reservoir temperature";
    parameter Real Qh(unit = "kJ") = 1000 "Energy received";
    parameter Real na(unit="-") = 0.6 "efficiency for(a)";
    //===============================
    
    //variable selection
    Real nmax(unit="-")"maximum thermal efficiency";
    //===============================
    
    //equation selection
  equation
    nmax = 1 - Tc / Th;  //maximum thermal efficiency
    
    if (na < nmax) then
     Modelica.Utilities.Streams.print("cycle operates irreversibly for (a)");
    end if;
    
    
  end Ex5_1_a;
  //===============================

 
 
  model Ex5_1_b
    //Given Qh=1000kJ, Wc=850kJ
    
    //===============================
    extends Ex5_1_a;
    //===============================
  
    //parameter selection
    parameter Real Wc(unit="kJ")=850"Work done in a cycle";
    //===============================
    
    //variable selction
    Real nb(unit="-")"effciency for (b)";
    //===============================
    
    //equation selection
    equation
    nb=Wc/Qh;   //Thermal efficiency
    if (nb > nmax) then
      Modelica.Utilities.Streams.print("power cycle is impossible for (b)"); 
     end if; 
  end Ex5_1_b;
//===============================


  model Ex5_1_c
      //Given Qh=1000kJ, Qc=200kJ
      
      //===============================
      extends Ex5_1_a;
      //===============================
     
      //parameter selection
      parameter Real Qc(unit="kJ")=200"Heat rejected to cold reservoir";
      //===============================
      
      //variable selection
      Real nc(unit="-")"efficiency for (c)";
      Real Wc(unit="kJ")"Work in cycle";
      //===============================
      
      //equation selection
      equation
        nc=Wc/Qh;  //Thermal efficiency
        Wc=Qh-Qc;  //Energy balance
          if nc == nmax then
     Modelica.Utilities.Streams.print("cycle operates reversibly for (c)");
     end if;
      end Ex5_1_c;
      //===============================
      
    end Ex5_1;
