/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-5,The second law of thermodynamics
//Example 5_3 Page:170
//Title:Evaluating heat pump performance
//===============================
package Ex5_3
  model Ex5_3_a
    //To calculate the minimum work required
    //===============================
    
    //parameter selection
    parameter Real Qh(unit = "Btu/day") = 5e5 "Heat required";
    parameter Real Th(unit = "F") = 70 "Building temperature";
    parameter Real Tc(unit = "F") = 32 "Outside temperature";
    //===============================
    
    //variable selection
    Real Vmax(unit = "-")"Maximum coefficient of performance";
    Real Wc(unit = "Btu/day") "Work for heat pump cycle";
    //===============================
    
    //equation selection
    equation
    Vmax = (Th + 459.67) / ((Th + 459.67 )- (Tc + 459.67));//coefficient of performance
                                                           //Adding 459.67 to convert in Rankine scale
    Wc = Qh / Vmax;                                        //Work for heat pump cycle
  end Ex5_3_a;

  //===============================


  model Ex5_3_b
  //To calculate the total cost of electricity
  
  //===============================
    extends Ex5_3_a;
   //===============================
  
    //parameter selection
     parameter Real cost(unit="$/kW.h")=0.13"cost of electricity per kW";
   //===============================
   
   //variable selection
    Real Tcost(unit="$/day")"Total cost per day";
   //===============================
   
   //equation selection
     equation
     Tcost=Wc*cost/3413;     //Dividing by 3413 to convert Btu into kW.h

  end Ex5_3_b;
  //===============================
end Ex5_3;
