/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-6,Using Entropy
//Example 6_11 Page:213
//Title:Determining Turbine Work Using the Isentropic Efficiency
//===============================
model Ex6_11

    //parameter selection
    parameter Real n(unit="-")=0.75"efficiency";
    parameter Real h1(unit="kJ/kg")=3105.6"specific enthalpy at state 1";   /*From Table A-4 at 
                                                                            P=5 bar and T=320 C. 
                                                                            Appendix Pg:A-8*/
    parameter Real h2s(unit="kJ/kg")=2743.0"specific enthalpy at state 2";  /*From Table A-4 
                                                                            at P=1 bar. Appendix Pg:A-7*/
    //===============================
    
    //variable selection
    Real Wcv(unit="kJ/kg")"work develpoed per unit mass";
    //===============================
    
    //equation selection
    equation
      Wcv=n*(h1-h2s);     //From Eq 6.46, Pg:213

end Ex6_11;
//===============================
