/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-6,Using Entropy
//Example 6_12 Page:214
//Title:Evaluating Isentropic Turbine Efficiency
//===============================
model Ex6_12

    //parameter selection
    parameter Real p1(unit="bar")=3.0"initial pressure";
    parameter Real p2(unit="bar")=1.0"final pressure";
    parameter Real T1(unit="K")=390"initial temperature";          
    parameter Real pr1(unit="-")=3.481"relative pressure at state 1";    
    parameter Real h1(unit="kJ/kg")=390.88"specific enthalpy at state 1";  
                                                                    /*From Table A-22 
                                                                    for T=390 K. 
                                                                    Appendix Pg:A-39*/
    parameter Real Wcv(unit="kJ/kg")=74"actual work developed rate";
    parameter Real h2s(unit="kJ/kg")=285.27"specific enthalpy after isentropic expansion";  
                                                                    /*From Table A-22 
                                                                    for pr=1.1603. 
                                                                    Appendix Pg:A-39*/
    //===============================
    
    //variable selection                                                               
    Real pr2s(unit="-")"relative pressure at isentropic expansion state 2";
    Real Wcvs(unit="kJ/kg")"work developed rate in an isentropic expansion";
    Real nt(unit="-")"isentropic turbine efficiency";
    //===============================
    
    //equation selection
    equation
      pr2s/pr1=p2/p1;     //From Eq 6.41, Pg:208
      Wcvs=h1-h2s;
      nt=Wcv/Wcvs;        //From Eq 6.46, Pg:213

end Ex6_12;
//===============================
