/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-6,Using Entropy
//Example 6_14 Page:217
//Title:Evaluating Isentropic Compressor Efficiency
//===============================
package Ex6_14
  model Ex6_14_a   
//To calculate using data from property tables
      
      //parameter selection
      parameter Real h2(unit="kJ/kg")=294.17"specific enthalpy of refrigerant at state 2";   
                                                                          /*From Table A-9
                                                                          at P=14 bar and T=75 C.
                                                                          Appendix Pg:A-18*/
      parameter Real h2s(unit="kJ/kg")=285.58"specific enthalpy of refrigerant at isentropic exit state 2s";   
                                                                          /*From Table A-9, interpolating 
                                                                          s1=0.9572 kJ/kg at P=14 bar.  
                                                                          Appendix Pg:A-18*/
      parameter Real h1(unit="kJ/kg")=249.75"specific enthalpy of refrigirant at state 1";  
                                                                          /*From Table A-9
                                                                          at P=3.5 bar and T=-5 C.
                                                                          Appendix Pg:A-16*/
      parameter Real m(unit="kg/s")=0.07"mass flow rate";                 /*using result of Ex 6.8*/
      //===============================
      
      //variable selection
      Real Wcv(unit="kW")"power";
      Real nc(unit="-") "isentropic efficieny";
      //===============================
      
      //equation selection
      equation
        Wcv=m*(h1-h2);        //Reduced mass and energy rate balance
        nc=(h2s-h1)/(h2-h1);  //Isentropic compressor efficiency
      
  end Ex6_14_a;

  //===============================
end Ex6_14;
