/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-6,Using Entropy
//Example 6_15 Page:221
//Title:Determining Work and Heat Transfer for a Polytropic Compression of Air
//===============================
model Ex6_15
    //parameter selection
    parameter Real p1(unit="bar")=1"inlet air pressure";
    parameter Real p2(unit="bar")=5"exit air presure";
    parameter Real T1(unit="C")=20"inlet air temperature";
    parameter Real n(unit="-")=1.3"polytropic index";
    parameter Real h1(unit="kJ/kg")=293.17"specific enthalpy of air at inlet";  
                                                                      /*From Table A-22 
                                                                      for T=293.15 K. 
                                                                      Appendix Pg:A-39*/
    parameter Real h2(unit="kJ/kg")=426.35"specific enthalpy of air at exit";  
                                                                      /*From Table A-22 
                                                                      for T=425 K. 
                                                                      Appendix Pg:A-39*/
    final constant Real R(final unit="kJ/kmol.K")=8.314 "gas constant";
    final constant Real M(final unit="kg/kmol")=28.97 "molecular mass of air";
    //===============================
    
    //variable selection   
    Real Wcv(unit="kJ/kg")"work per unit mass";
    Real Qcv(unit="kJ/kg")"heat transfer per unit mass";
    Real T2(unit="K")"exit temperature";
    //===============================
    
    //equation selection
    equation
      T2/(T1+273.15)=(p2/p1)^((n-1)/n);      //From Eq 3.56 Pg:101
      Wcv=-n*(R/M)*(T2-(T1+273.15))/(n-1);   //From Eq 6.55a Pg:220
                                             //Adding 273.15 to convert into Kelvin scale
      Qcv=Wcv+h2-h1;                         //Reduced mass and energy rate balance

end Ex6_15;
//===============================
