/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-6,Using Entropy
//Example 6_2 Page:192
//Title:Determining Work and Entropy Production for an Irreversible Process of Water
//===============================
model Ex6_2

    //parameter selection
    parameter Real T(unit="C")=150"initial temperature";
    parameter Real u1(unit="kJ/kg")=631.68"specific internal energy of saturated liquid";
    parameter Real u2(unit="kJ/kg")=2559.5"specific internal energy of saturated vapour";
    parameter Real s1(unit="kJ/kg.K")=1.8418"specific entropy of saturated liquid";
    parameter Real s2(unit="kJ/kg.K")=6.8379"specific entropy of saturated vapour";
                                                             /*From Table A-2 for T=150 C.
                                                             Appendix Pg:A-4*/
    //===============================
    
    //variable selection
    Real W(unit="kJ/kg")"work per unit mass";
    Real sigma(unit="kJ/kg.K")"entropy production per unit mass";
    //===============================
    
    //equation selection    
    equation
      W=-(u2-u1);                 //Work from energy balance
      sigma=s2-s1;                //Closed system entropy balance
                               
end Ex6_2;
//===============================
