/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-6,Using Entropy
//Example 6_9 Page:210
//Title:Analyzing an Isentropic Process of Air
//===============================
package Ex6_9
  model Ex6_9_a
  //To find final pressure from pr data
  
    //parameter selection
    parameter Real p1(unit = "atm") = 1 "initial pressure";
    parameter Real T1(unit = "R") = 540 "initial temperature";
    parameter Real T2(unit = "R") = 1160 "final temperature";
    parameter Real pr1(unit = "-") = 1.3860 "relative pressure at state 1"; 
                                                        /*From Table A-22E for T=540 R. 
                                                        Appendix Pg:A-89*/
    parameter Real pr2(unit = "-") = 21.18 "relative pressure at state 2";   
                                                        /*From Table A-22E for T=1160 R. 
                                                        Appendix Pg:A-89*/
    //===============================
    
    //variable selection
    Real p2a(unit = "atm") "final pressure";
    //===============================
    
    //equation selection
    equation
      p2a / p1 = pr2 / pr1;        //From Eq 6.41, Pg:208
  end Ex6_9_a;
  //===============================

  model Ex6_9_c
  //To find final pressure from specific heat ratio 
    //===============================  
    extends Ex6_9_a;
    //===============================
    
    //parameter selection
    parameter Real k(unit = "-")=1.39"specific heat ratio";           
                                                          /*From Table A-20E for T=350 F. 
                                                          Appendix Pg:A-87*/
    //===============================
    
    //variable selection
    Real p2c(unit="atm")"final pressure";
    //===============================
    
    //equation selection
    equation
      p2c/p1=(T2/T1)^(k/(k-1));      //From Eq 6.43, Pg:209
  
  end Ex6_9_c;
  //===============================
end Ex6_9;
