/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-7,Exergy Analysis
//Example 7_1 Page:231
//Title:Evaluating the Exergy of Exhaust Gas
//===============================
model Ex7_1
    //parameter selection
    parameter Real p(unit="bar")=7"pressure of gaseous combustion products";
    parameter Real T(unit="C")=867"temperature of gaseous combustion products";
    parameter Real p0(unit="bar")=1.013"pressure at dead state";
    parameter Real T0(unit="K")=300"temperature at dead state";
    parameter Real u(unit="kJ/kg")=880.35"specific internal energy of the combustion products";
    parameter Real sT(unit="kJ/kg")=3.11883"specific entropy of combustion products";
                                                                      /*From Table A-22 
                                                                      for T=1140 K. 
                                                                      Appendix Pg:A-40*/
    parameter Real u0(unit="kJ/kg")=214.07"specific internal energy at dead state";
    parameter Real sT0(unit="kJ/kg.K")=1.70203"specific entropy at dead state";
                                                                      /*From Table A-22 
                                                                      for T=1140 K. 
                                                                      Appendix Pg:A-40*/
    final constant Real R(final unit="kJ/kmol.K")=8.314 "gas constant";
    final constant Real M(final unit="kg/kmol")=28.97 "molecular mass of air";
    //===============================
    
    //variable selection
    Real v(unit="m3/kg")"specific volume of combustion products";
    Real v0(unit="m3/kg")"specific volume at dead state";
    Real del_s(unit="kJ/kg.K")"specific entropy difference";
    Real e(unit="kJ/kg")"specific exergy";
    //===============================
    
    //equation selection
    equation
      e=(u-u0)+p0*(v-v0)-T0*(del_s);     //Exergy equation
      del_s=sT-sT0-R/M*log((p/p0));
      v=R*(T+273.15)/(M*p);              //Adding 273.15 to convert into Kelvin scale
      v0=R*T0/(M*p0);                    //Ideal gas equation
end Ex7_1;
//===============================
