/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-7,Exergy Analysis
//Example 7_10 Page:258
//Title:Exergy Costing of a Cogeneration System
//===============================
package Ex7_10
  model Ex7_10_a
  //To find the power and the rate exergy exits with the steam for turbine
  
      //parameter selection
      parameter Real m(unit = "kg/s") = 26.15 "mass flow rate of process steam";
      parameter Real h1(unit = "kJ/kg") = 3353.54 "specific enthalpy of steam at turbine inlet";
      parameter Real s1(unit = "kJ/kg.K") = 6.8773 "specific entropy of steam at turbine inlet";
                                                                  /*From Table A-4 for 
                                                                  P=50 bar T=466 C. 
                                                                  Appendix Pg:A-9*/
      parameter Real h2(unit = "kJ/kg") = 2865.96 "specific enthalpy of steam at turbine exit";
      parameter Real s2(unit = "kJ/kg.K") = 7.0806 "specific entropy of steam at turbine exit";
                                                                  /*From Table A-4 for 
                                                                  P=5 bar T=205 C. 
                                                                  Appendix Pg:A-8*/
      parameter Real Ef1(unit = "MW") = 35 "exergy rate of steam at boiler exit";
      parameter Real T0(unit = "K") = 298 "temperature at dead state";
      //===============================
      
      //variable selection
      Real We(unit = "MW") "power developed by the turbine";
      Real Ef2(unit = "MW") "exergy rate of steam at turbine exit";
      //===============================
      
      //equation selection
      equation
        We = m * (h1 - h2) / 10 ^ 3;
        Ef2 = Ef1 + m * (h2 - h1 - T0 * (s2 - s1)) / 10 ^ 3;  //Exergy rate        
                                                              //Dividing by 10^3 to convert into MW
  end Ex7_10_a;
  //===============================

  model Ex7_10_b
  //To determine units of cost
  
      //===============================
      extends Ex7_10_a;
      //===============================
      
      //parameter selection
      parameter Real EfF(unit="MW")=100"exergy rate of flue at boiler inlet";
      parameter Real cF(unit="cents/kW.h")=1.44"unit costs of the fuel";
      parameter Real Zb(unit="$/h")=1080"cost rate associated with boiler";
      parameter Real Zt(unit="$/h")=92"cost rate associated with boiler";
      //===============================
      
      //variable selection
      Real c1(unit="cents/kW.h")"unit costs of exiting steam from boiler";
      Real c2(unit="cents/kW.h")"unit costs of exiting steam from turbine";
      Real ce(unit="cents/kW.h")"unit costs of power";
      //===============================
      
      //equation selection
      equation
        c1=c2;
        c1*Ef1=cF*EfF+(Zb/10^3)*100;            //From Eq.7.32(a), Pg:257
        ce*We+c2*Ef2=c1*Ef1+(Zt/10^3)*100;      //From Eq.7.34(a), Pg:257
                                                //Dividing by 10^3 to convert into MW
                                                //Multiplying by 100 to convert into cents
  end Ex7_10_b;
  //===============================

  model Ex7_10_c
  //To determine the cost rates of steam exiting and power
  
      //===============================
      extends Ex7_10_a;
      extends Ex7_10_b;
      //===============================
      
      //variable selection
      Real C2(unit="$/h")"cost rates of steam exiting turbine";
      Real Ce(unit="$/h")"cost rates of power";
      //===============================
      
      //equation selection
      equation
        C2=c2*Ef2*10^3/100;
        Ce=ce*We*10^3/100;       //Multiplying by 10^3 to convert into MW
                                 //Dividing by 100 to convert into cents

  end Ex7_10_c;
end Ex7_10;
