/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-7,Exergy Analysis
//Example 7_2 Page:235
//Title:Evaluating the Exergy of Exhaust Gas
//===============================
package Ex7_2
  model Ex7_2_a
    //To find the change in exergy per unit mass
    
    //parameter selection
    parameter Real T(unit = "K") = 423.15 "temperature at state 1";
    parameter Real T0(unit = "K") = 293.15 "temperature at dead state";
    parameter Real p0(unit = "bar") = 1 "pressure at dead state";
    parameter Real u1(unit = "kJ/kg") = 631.68 "specific internal energy at state 1";
    parameter Real v1(unit = "m3/kg") = 1.0905e-3 "specific volume at state 1";
    parameter Real s1(unit = "kJ/kg.K") = 1.8418 "specific entropy at state 1";
    parameter Real u2(unit = "kJ/kg") = 2559.5 "specific internal energy at state 2";
    parameter Real v2(unit = "m3/kg") = 0.3928 "specific volume at state 2";
    parameter Real s2(unit = "kJ/kg.K") = 6.8379 "specific entropy at state 2";
                                                              /*Data from Example 6.1, Pg:235*/
    //===============================
    
    //variable selection
    Real del_e(unit = "kJ/kg") "change in exergy";
    //===============================
    
    //equation selection
    equation
      del_e = u2 - u1 + p0 * (v2 - v1) * (10 ^ 5 / 10 ^ 3) - T0 * (s2 - s1);  //Exergy equation
                                                           //Multiplying by 10^5 to convert into N/m^2
                                                           //Dividing by 10^3 to convert into kJ
  end Ex7_2_a;

  //===============================

  model Ex7_2_b
  //To find exergy transfer accompanying heat transfer per unit mass
  
      //===============================
      extends Ex7_2_a;
      //===============================
      
      //parameter selection
      parameter Real Qm(unit="kJ/kg")=2114.1"heat transfer per unit mass";   /*Data from Example 6.1, Pg:235*/
      //===============================
      
      //variable selection
      Real Eqm(unit="kJ/kg")"exergy accompanying heat transfer per unit mass";
      //===============================
      
      //equation selection
      equation
        Eqm=(1-(T0/T))*Qm;           //From Eq 7.5, Pg:234
      
  end Ex7_2_b;
  //===============================

      model Ex7_2_c
      //To find the exergy accompanying work per unit mass
      
      //===============================
      extends Ex7_2_a;
      //===============================
      
      //parameter selection
      parameter Real Wm(unit="kJ/kg")=186.38"work per unit mass";
      //===============================
      
      //variable selection
      Real Ewm(unit="kJ/kg")"exergy accompanying work per unit mass";
      //===============================
      
      //equation selection
      equation
        Ewm=Wm-p0*(v2-v1)*(10^5/10^3);    //From Eq 7.6, Pg:234
                                          //Multiplying by 10^5 to convert into N/m^2
                                          //Dividing by 10^3 to convert into kJ
  end Ex7_2_c;

  model Ex7_2_d
  //To find the exergy destruction per unit mass
  
      //===============================
      extends Ex7_2_a;
      extends Ex7_2_b;
      extends Ex7_2_c;
      //===============================
      
      //variable selection
      Real Edm(unit="kJ/kg")"exergy destruction per unit mass";
      //===============================
      
      //equation selection
      equation
        Edm=-del_e+Eqm-Ewm;   //From Eq 7.4b, Pg:233
  end Ex7_2_d;
  //===============================
end Ex7_2;
//The  answer may slightly vary due to  rounding off values
    
/*Variable       Obtained answer      Book answer
Edm              -0.10097             0           */
