/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-7,Exergy Analysis
//Example 7_4 Page:239
//Title:Exergy Accounting of a Gearbox
//===============================
model Ex7_4

    //parameter selection
    parameter Real Q(unit="kW")=-1.2"heat transfer rate";
    parameter Real W1(unit="kW")=-60"input power";
    parameter Real W2(unit="kW")=58.8"output power";
    parameter Real Tb(unit="K")=300"temperature of the surrounding";
    parameter Real T0(unit="K")=293"temperature at the dead state";
    //===============================
    
    //variable selection
    Real Eq(unit="kW")"exergy transfer rate accompanying heat transfer";
    Real Ed(unit="kW")"exergy destruction rate";
    Real W(unit="kW")"net power";
    Real tot_Ed(unit="kW")"total disposition of exergy";
    Real error(unit="%")"error percent in total exergy";
    String result;
    //===============================
    
    //equation selection
    equation
        W=W1+W2;
        Eq=(1-(T0/Tb))*Q;      //From Eq 7.12, Pg:237
        Ed=Eq-W;               //From Eq 7.11(b), Pg:237
        tot_Ed=W2+Ed+Eq;                 
        
        if -1*W1 == tot_Ed then
          result = "exergy balance sheet satisfied";
        else
          error=(-1*W1-tot_Ed)/(-1*W1)*100;
          if error < 2 then 
            result = "exergy balance sheet satisfied";
          else
            result = "exergy balance sheet not satisfied";
          end if;
        end if;
        
        Modelica.Utilities.Streams.print(result);
end Ex7_4;
//===============================
