/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-7,Exergy Analysis
//Example 7_5 Page:243
//Title:Determining Exergy Destruction in a Throttling Valve
//===============================
model Ex7_5

    //parameter selection
    parameter Real T0(unit="K")=77"temperature at dead state";
    parameter Real s1(unit="Btu/lb.R")=1.4923"specific entropy at inlet";  /*From Table A-4E 
                                                                           for P=500 lbf/in^2 
                                                                           and T= 500 F.
                                                                           Appendix Pg:A-58*/
    parameter Real s2(unit="Btu/lb.R")=1.680"specific entropy at exit";    /*From Table A-4E by 
                                                                           interpolating at 
                                                                           h=1231.5 Btu/lb and
                                                                           p=80 lbf/in^2. 
                                                                           Appendix Pg:A-56*/
    //===============================
    
    //variable selection
    Real Edm(unit="Btu/lb")"exergy destruction per unit mass";
    //===============================
    
    //equation selection
    equation
      Edm=(T0+459.67)*(s2-s1);    //Adding 459.67 to convert into Rankein scale
end Ex7_5;
//===============================
