/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-7,Exergy Analysis
//Example 7_7 Page:246
//Title:Determining Cost of Exergy Destruction
//===============================
model Ex7_7
    //parameter selection
    parameter Real T0(unit="K")=273"temperature at dead state";
    parameter Real sigmacomp(unit="kW/K")=17.5e-4"entropy production rate of compressor";
    parameter Real sigmavalve(unit="kW/K")=9.94e-4"entropy production rate of valve";
    parameter Real sigmacond(unit="kW/K")=7.95e-4"entropy production rate of condensor";  
                                                                    /*From data for the 
                                                                    entropy production rates 
                                                                    from Example 6.8*/
    parameter Real cost(unit="$/kW.h")=0.08"cost of exergy per kW.h";
    parameter Real P(unit="kW")=3.11"compressor power";
                                                                    /*From the solution to 
                                                                    Example 6.14, the magnitude 
                                                                    of the compressor power*/
    //===============================
    
    //variable selection                                                               
    Real Edcomp(unit="kW")"exergy destruction rate of compressor";
    Real Edvalve(unit="kW")"exergy destruction rate of valve";
    Real Edcond(unit="kW")"exergy destruction rate of condensor";
    Real costcomp(unit="$")"daily cost of exergy destruction due to compressor";
    Real costvalve(unit="$")"daily cost of exergy destruction due to valve";
    Real costcond(unit="$")"daily cost of exergy destruction due to condensor";
    Real oper_cost(unit="$")"daily cost of electricity to operate compressor";
    //===============================
    
    //equation selection
    equation
      Edcomp=T0*sigmacomp;
      Edvalve=T0*sigmavalve;
      Edcond=T0*sigmacond;        //Rate of exergy destruction
      costcomp=Edcomp*cost*24;
      costvalve=Edvalve*cost*24;
      costcond=Edcond*cost*24;    //Daily cost of exergy destruction
      oper_cost=P*cost*24;        //Daily cost of electricity to operate compressor
end Ex7_7;
//===============================
