/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-8,Vapor Power Systems
//Example 8_2 Page:278
//Title:Analyzing a Rankine Cycle with Irreversibilities
//===============================
package Ex8_2
  model Ex8_2_a
  //To find thermal efficiency
      parameter Real p3(unit = "MPa") = 0.008 "pressure at state 3";
      parameter Real p4(unit = "MPa") = 8.0 "pressure at state 4";
      parameter Real h1(unit = "kJ/kg") = 2758.0 "specific enthalpy at state 1";
      parameter Real s1(unit = "kJ/kg.K") = 5.7432 "specific entropy at state 1";
                                                                        /*From Table A-3 at 
                                                                        P= 8.0 MPa for saturated vapour. 
                                                                        Appendix Pg:A-5*/
      parameter Real sf(unit = "kJ/kg.K") = 0.5926 "specific entropy of saturated liquid at state 2";
      parameter Real sg(unit = "kJ/kg.K") = 8.2287 "specific entropy of saturated vapour at state 2";
      parameter Real hf(unit = "kJ/kg") = 173.88 "specific enthalpy of saturated liquid at state 2";
      parameter Real hfg(unit = "kJ/kg") = 2403.1 "specific enthalpy difference at state 2";
                                                                        /*From Table A-3 at P= 0.008 MPa. 
                                                                        Appendix Pg:A-5*/
      parameter Real v3(unit = "m3/kg") = 1.0084e-3 "specific volume at state 3";
                                                                        /*From Table A-3 at 
                                                                        P= 0.008 MPa for saturated liquid. 
                                                                        Appendix Pg:A-5*/
      parameter Real nt(unit = "-") = 0.85 "isentropic turbine efficiency";
      //===============================
      
      //variable selection
      Real s2(unit = "kJ/kg.K") "specific entropy at state 2";
      Real h2(unit = "kJ/kg") "specific enthalpy at state 2";
      Real h2s(unit = "kJ/kg") "specific enthalpy at state 2s";
      Real h3(unit = "kJ/kg") "specific enthalpy at state 3";
      Real h4(unit = "kJ/kg") "specific enthalpy at state 4";  
      Real n(unit = "-") "thermal efficiency";
      Real x2(unit = "-") "vapour quality at state 2";
      //===============================
      
      //equation selection
      equation
        h3 = hf;
        s2 = s1;
        x2 = (s2 - sf) / (sg - sf);                           //Quality for liquid-vapour mixture
        h2s = hf + x2 * hfg;                                  //Enthalpy from quality
        h2 = h1 - nt * (h1 - h2s);                            //Isentropic turbine efficiency
        h4 = h3 + v3 * (p4 - p3) / nt * (10 ^ 6 / 10 ^ 3);    //From Eq. 8.10(b) Pg:277
                                                              //Multiplying by 10^6 to convert into Pa
                                                              //Dividing by 10^3 to convert into kJ
        n = (h1 - h2 - (h4 - h3)) / (h1 - h4);                //Thermal efficiency
  end Ex8_2_a;

  model Ex8_2_b
  //To find mass flow rate
  
      //===============================
      extends Ex8_2_a;
      //===============================
      
      //parameter selection
      parameter Real Wcycle(unit="MW")=100"net power output of the cycle";
      //===============================
      
      //variable selection
      Real m(unit="kg/h")"mass flow rate";
      //===============================
      
      //equation selection
      equation
        m=Wcycle*10^3*3600/((h1-h2)-(h4-h3));        //From net work Eq given in part (a) Pg:278
                                                     //Multiplying by 10^3 to convert into kW
                                                     //Multiplying by 3600 to convert into per hour
  end Ex8_2_b;

  model Ex8_2_c
  //To find rate of heat transfer into the working fluid
  
      //===============================
      extends Ex8_2_a;
      extends Ex8_2_b;
      //===============================
      
      //variable selection
      Real Qin(unit="MW")"heat transfer rate into working fluid";
      //===============================
      
      //equation selection
      equation
        Qin=m*(h1-h4)/(3600*10^3);      //From Eq.8.4 Pg:270
                                        //Dividing by (3600*10^3) to convert into MW

  end Ex8_2_c;

  model Ex8_2_d
  //To find rate of heat transfer from the condensing steam
  
      //===============================
      extends Ex8_2_a;
      extends Ex8_2_b;
      //===============================
      
      //variable selection
      Real Qout(unit="MW")"heat transfer rate from condensing steam";
      //===============================
      
      //equation selection
      equation
        Qout=m*(h2-h3)/(3600*10^3);           //From Eq.8.2 Pg:270
                                              //Dividing by (3600*10^3) to convert into MW

  end Ex8_2_d;

  model Ex8_2_e
  //To find mass flow rate of condenser cooling water
  
      //===============================
      extends Ex8_2_a;
      extends Ex8_2_b;
      //===============================
      
      //parameter selection
      parameter Real hcwout(unit="kJ/kg")=146.68"specific enthalpy of outlet cooling water";
      parameter Real hcwin(unit="kJ/kg")=62.99"specific enthalpy of inlet cooling water";
      //===============================
      
      //variable selection
      Real mcw(unit="kg/s")"mass flow rate of cooling water";
      //===============================
      
      //equation selection
      equation
        mcw=m*(h2-h3)/(hcwout-hcwin);     //Reduced mass and energy rate balance

  end Ex8_2_e;
end Ex8_2;
