/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-8,Vapor Power Systems
//Example 8_4 Page:283
//Title:Evaluating Performance of a Reheat Cycle with Turbine Irreversibility
//===============================
package Ex8_4
  model Ex8_4_a
  //To find the thermal efficiency of the cycle
  
      //parameter selection
      parameter Real h1(unit = "kJ/kg") = 3348.4 "specific enthalpy at state 1";
      parameter Real s1(unit = "kJ/kg") = 6.6586 "specific entropy at state 1";
                                                                          /*From Table A-4 for
                                                                          P=8.0 MPa and T=480 C. 
                                                                          Appendix Pg"A-8*/
      parameter Real hf2(unit = "kJ/kg") = 697.22 "specific enthalpy of saturated liquid at state 2";
      parameter Real hfg2(unit = "kJ/kg") = 2066.3 "specific enthalpy difference at state 2";
      parameter Real sf2(unit = "kJ/kg.K") = 1.9922 "specific entropy of satuarted liquid at state 2";
      parameter Real sg2(unit = "kJ/kg.K") = 6.708 "specific entropy of saturated vapour at state 2";
                                                                          /*From Table A-3 
                                                                          for P=0.7 MPa. 
                                                                          Appendix Pg:A-5*/
      parameter Real h3(unit = "kJ/kg") = 3353.3 "specific enthalpy at state 3";
      parameter Real s3(unit = "kJ/kg.K") = 7.7571 "specific entropy at state 3";
                                                                          /*From Table A-4 for 
                                                                          P=0.7 MPa and T=440 C. 
                                                                          Appendix Pg:A-8*/
      parameter Real hf4(unit = "kJ/kg") = 173.88 "specific enthalpy of staurated liquid at state 4";
      parameter Real hg4(unit = "kJ/kg") = 2577.0 "specific enthalpy of sturated vapour at state 4";
      parameter Real sf4(unit = "kJ/kg.K") = 0.5926 "specific entropy of saturated liquid at state 4";
      parameter Real sg4(unit = "kJ/kg.K") = 8.2287 "specific entropy of staturated vapour at state 4";
                                                                          /*From Table A-3 for 
                                                                          P=0.008 MPa. 
                                                                          Appendix Pg:A-5*/
      parameter Real h6(unit = "kJ/kg") = 181.94 "specific enthalpy at state 6";
      parameter Real nt(unit = "-") = 0.85 "isentropic turbine efficiency";
      //===============================
      
      //variable selection
      Real s2(unit = "kJ/kg.K") "specific entropy at state 2";
      Real s4(unit = "kJ/kg.K") "specific entropy at state 4";
      Real h2s(unit = "kJ/kg") "specific enthalpy at state 2s";
      Real h2(unit = "kJ/kg") "specific enthalpy at state 2";
      Real h4s(unit = "kJ/kg") "specific enthalpy at state 4s";
      Real h4(unit = "kJ/kg") "specific enthalpy at state 4";
      Real h5(unit = "kJ/kg") "specific enthalpy at state 5";
      Real x2(unit = "-") "vapour quality at state 2";
      Real x4(unit = "-") "vapour quality at state 4";
      Real n(unit = "-") "thermal efficiency";
      //===============================
      
      //equation selection
      equation
        s2 = s1;
        x2 = (s2 - sf2) / (sg2 - sf2);                               //Quality of liquid-vapour mixture
        h2s = hf2 + x2 * hfg2;                                       //Enthalpy of liquid-vapour mixture
        h2 = h1 - nt * (h1 - h2s);
        s4 = s3;
        x4 = (s4 - sf4) / (sg4 - sf4);                               //Quality of liquid-vapour mixture
        h4s = hf4 + x4 * (hg4 - hf4);                                //Enthalpy of liquid-vapour mixture
        h4 = h3 - nt * (h3 - h4s);
        h5 = hf4;
        n = (h1 - h2 + h3 - h4 - (h6 - h5)) / (h1 - h6 + h3 - h2);  //Thermal efficiency
  end Ex8_4_a;

end Ex8_4;
