/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-8,Vapor Power Systems
//Example 8_5 Page:286
//Title:Considering a Regenerative Cycle with Open Feedwater Heater
//===============================
package Ex8_5
  model Ex8_5_a
  //To find thermal efficiency
  
    //parameter selection
    parameter Real p4(unit = "MPa") = 0.008 "pressure at state 4";
    parameter Real p5(unit = "MPa") = 0.7 "pressure at state 5";
    parameter Real p6(unit = "MPa") = 0.7 "pressure at state 4";
    parameter Real p7(unit = "MPa") = 8.0 "pressure at state 5";
    parameter Real h1(unit = "kJ/kg") = 3348.4 "specific enthalpy at state 1";
                                                                         /*From Table A-a at 
                                                                         P=8.0 MPa and T=480 C. 
                                                                         Appendix Pg:A-9*/                 
    parameter Real h2(unit = "kJ/kg") = 2832.8 "specific enthalpy at state 2";
    parameter Real s2(unit = "kJ/kg.K") = 6.8606 "specific entropy at state 2";
                                                                         /*From Table A-3 at P=0.7 MPa 
                                                                         for quality of vapour=0.9895.                                            
                                                                         Appendix Pg:A-5*/
    parameter Real h3s(unit = "kJ/kg") = 2146.3 "specific enthalpy at state 3s";
                                                                         /*From Table A-3 at 
                                                                         S=6.8606 and vapour quality = 0.8208.
                                                                         Appendix Pg:A-5*/
    parameter Real h4(unit = "kJ/kg") = 173.88 "specific enthalpy at state 4";
    parameter Real v4(unit = "m3/kg") = 1.0084e-3 "specific volume at state 4";
                                                                         /*From Table A-3 at P=0.008 MPa 
                                                                         for saturated liquid. 
                                                                         Appendix Pg:A-5*/
    parameter Real h6(unit = "kJ/kg") = 697.22 "specific enthalpy at state 6";
    parameter Real v6(unit = "kJ/kg") = 1.1080e-3 "specific volume at state 6";
                                                                         /*From Table A-3 at P=0.7 MPa 
                                                                         for saturated liquid. 
                                                                         Appendix Pg:A-5*/
    parameter Real nt(unit = "-") = 0.85 "isentropic efficiency";
    //===============================
    
    //variable selection
    Real h3(unit = "kJ/kg") "specific enthalpy at stste 3";
    Real h5(unit = "kJ/kg") "specific enthalpy at stste 5";
    Real h7(unit = "kJ/kg") "specific enthalpy at stste 7";
    Real Wt_m1(unit = "kJ/kg") "turbine output work per unit mass";
    Real Wp_m1(unit = "kJ/kg") "pump work per unit mass";
    Real Qin_m1(unit = "kJ/kg") "heat added in the steam generator per unit mass";
    Real y(unit = "-") "fraction of flow extracted from state 2";
    Real n(unit = "-") "thermal efficiency";
    //===============================
    
    //equation selection
    equation
    h3 = h2 - nt * (h2 - h3s);                    //Enthaply from isentropic efficiency
    h5 = h4 + v4 * (p5 - p4) * (10 ^ 6 / 10 ^ 3); //From Eq. 3.13, Pg:82
    h7 = h6 + v6 * (p7 - p6) * (10 ^ 6 / 10 ^ 3); //Mulitiplying by (10^6/10^3) to convert into kJ/kg
    y = (h6 - h5) / (h2 - h5);
    Wt_m1 = h1 - h2 + (1 - y) * (h2 - h3);        //Modified Turbine output work from Eq.8.1, Pg:270
    Wp_m1 = h7 - h6 + (1 - y) * (h5 - h4);        //Modified Pump work from Eq.8.3, Pg:270
    Qin_m1 = h1 - h7;                             //From Eq. 8.2, Pg:270
    n = (Wt_m1 - Wp_m1) / Qin_m1;                 //Thermal efficiency
  
  end Ex8_5_a;
  //===============================

  model Ex8_5_b
  //To find mass flow rate of steam entering first turbine stage
        
      //===============================
      extends Ex8_5_a;
      //===============================
      
      //parameter selection
      parameter Real Wcycle(unit = "MW") = 100 "net power output of the cycle";
      //===============================
      
      //variable selection
      Real m1(unit = "kg/h") "mass flow rate";
      //===============================
      
      //equation selection
      equation
        m1 = Wcycle * 3600 * 10 ^ 3 / (Wt_m1 - Wp_m1);  //Net work
                                                        //Multiplying by 10^3 to convert into kW
                                                        //Multiplying by 3600 to convert into per hour
  end Ex8_5_b;
  //===============================
end Ex8_5;
