/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-8,Vapor Power Systems
//Example 8_8 Page:299
//Title:Vapor Cycle Exergy Analysis—Turbine and Pump
//===============================
model Ex8_8
    
    //parameter selection
    parameter Real s1(unit="kJ/kg.K")=5.7432"specific entropy at state 1";
                                                                        /*From Table A-3 at 
                                                                        P= 8.0 MPa for saturated vapour. 
                                                                        Appendix Pg:A-5*/
    parameter Real s2(unit="kJ/kg.K")=6.2021"specific entropy at state 2";
                                                                        /*From Table A-3 at 
                                                                        h=1939.3 kJ/kg. 
                                                                        Appendix Pg:A-5*/
    parameter Real s3(unit="kJ/kg.K")=0.5926"specific entropy at state 3";
                                                                        /*From Table A-3 at 
                                                                        P= 0.008 MPa for saturated liquid. 
                                                                        Appendix Pg:A-5*/
    parameter Real s4(unit="kJ/kg.K")=0.5957"specific entropy at state 4";
    parameter Real net_egas(unit="MW")=231.28"rate to exergy supply by cooling combustion gas";
    parameter Real m(unit="kg/h")=4.449e5"mass flow rater of water";
                                                                        /*From solution to 
                                                                        Example 8.7, Pg:298*/
    parameter Real T0(unit="K")=295"temperature at the dead state";
    parameter Real fuel(unit="-")=0.69"percentage of exergy entering the plant with the fuel remains";
    parameter Real Wcycle(unit="MW")=100"net power output";
    //===============================
    
    //variable selection
    Real Edt(unit="MW")"rate of exergy destruction for the turbine";
    Real Edp(unit="MW")"rate of exergy destruction for the pump";
    Real Edt_percent(unit="%")"percentage turbine rate exergy destruction";
    Real Edp_percent(unit="%")"percentage pump rate exergy destruction";
    Real percent_tloss(unit="%")"percent of exergy destruction in turbine after considering loss";
    Real percent_ploss(unit="%")"percent of exergy destruction in pump after considering loss";
    Real Ef(unit="%")"percentage rate at which exergy is carried into the plant with fuel";
    //===============================
    
    //equation selection
    equation
      Edt=m*T0*(s2-s1)/(3600*10^3);
      Edp=m*T0*(s4-s3)/(3600*10^3);     //Exergy destruction rate
                                        //Dividing by (3600*10^3) to convert into MW
      Edt_percent=Edt/net_egas*100;
      Edp_percent=Edp/net_egas*100;
      percent_tloss=fuel*Edt_percent;
      percent_ploss=fuel*Edp_percent;
      Ef=Wcycle/net_egas*fuel*100;
end Ex8_8;
  //===============================
//The  answer may slightly vary due to  rounding off values
/*Variable       Obtained answer      Book answer
Edp_percent      0.0488659            0.03 */
