/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-9,Gas Power Systems
//Example 9_12 Page:340
//Title:Energy and Exergy Analyses of a Combined Gas Turbine-Vapor Power Plant
//===============================
package Ex9_12
  model Ex9_12_a
  
      //parameter selection
      parameter Real h1(unit = "kJ/kg") = 300.19 "specific enthalpy at state 1";
      parameter Real h2(unit = "kJ/kg") = 669.79 "specific enthalpy at state 2";
      parameter Real h3(unit = "kJ/kg") = 1515.42 "specific enthalpy at state 3";
      parameter Real h4(unit = "kJ/kg") = 858.02 "specific enthalpy at state 4";
      parameter Real h5(unit = "kJ/kg") = 400.98 "specific enthalpy at state 5";
      parameter Real h6(unit = "kJ/kg") = 183.96 "specific enthalpy at state 6";
      parameter Real h7(unit = "kJ/kg") = 3138.30 "specific enthalpy at state 7";
      parameter Real h8(unit = "kJ/kg") = 2104.74 "specific enthalpy at state 8";
      parameter Real h9(unit = "kJ/kg") = 173.88 "specific enthalpy at state 9";          
                                                                  /*From Table Gas Turbine and Vapour Cycle 
                                                                  from Example 9.12. Pg:341*/
      parameter Real Wnet(unit = "MW") = 45 "net power output";
      //===============================
      
      //variable selection
      Real mg(unit = "kg/s") "mass flow rate of gas";
      Real mv(unit = "kg/s") "mass flow rate of vapour";
      Real Wgas(unit = "MW") "net power developed by gas turbine";
      Real Wvap(unit = "MW") "net power developed by vapour power cycle";
      Real Qin(unit = "MW") "heat transfer rate";
      Real n(unit = "-") "thermal efficiency";
      //===============================
      
      //equation selection
      equation
        0 = mg * (h4 - h5) + mv * (h6 - h7);            //Reduced mass and energy balance
        Wgas = mg * (h3 - h4 - (h2 - h1)) / 10 ^ 3;
        Wvap = mv * (h7 - h8 - (h6 - h9)) / 10 ^ 3;  
        Qin = mg * (h3 - h2) / 10 ^ 3;                  //Reduced mass and energy balance
                                                        //Dividing by 10^3 to convert into MW
        n = Wnet / Qin;                                 //Thermal efficiency
        Wnet = Wgas + Wvap;
  end Ex9_12_a;
  //===============================

model Ex9_12_b

      //===============================
      extends Ex9_12_a;
      //===============================
      
      //parameter selection
      parameter Real T0(unit="K")=300"temperature at the dead state";
      parameter Real p0(unit="kPa")=100"pressure at the dead state";
      parameter Real s1(unit="kJ/kg.K")=1.7020"specific enthalpy at state 1";
      parameter Real s2(unit="kJ/kg.K")=2.5088"specific enthalpy at state 2";
      parameter Real s3(unit="kJ/kg.K")=3.3620"specific enthalpy at state 3";
      parameter Real s4(unit="kJ/kg.K")=2.7620"specific enthalpy at state 4";
      parameter Real s5(unit="kJ/kg.K")=1.9919"specific enthalpy at state 5";
      parameter Real s6(unit="kJ/kg.K")=0.5975"specific enthalpy at state 6";
      parameter Real s7(unit="kJ/kg.K")=6.3634"specific enthalpy at state 7";
      parameter Real s8(unit="kJ/kg.K")=6.7282"specific enthalpy at state 8";
      parameter Real s9(unit="kJ/kg.K")=0.5926"specific enthalpy at state 9";           
                                                       /*From Table Gas Turbine and Vapour Cycle 
                                                       from Example 9.12. Pg:341*/
      parameter Real p3(unit="kPa")=1200"pressure at state 3";
      parameter Real p4(unit="kPa")=100"pressure at state 4";
      parameter Real p2(unit="kPa")=1200"pressure at state 2";
      parameter Real p1(unit="kPa")=100"pressure at state 1";
      final constant Real R(final unit="kJ/kmol.K")=8.314"gas constant";
      final constant Real M(final unit="kg/kmol")=28.97"molecular mass of air"; 
                                                      /*From Table A-1. Appendix Pg:A-2*/
      //===============================
      
      //variable selection
      Real Ef32(unit="MW")"net exergy increase rate of air through combustor";
      Real Ef51(unit="MW")"net exergy rate carried out of plant by air";
      Real Ef89(unit="MW")"net exergy rate carried out as water";
      Real Edt(unit="MW")"exergy destruction for air turbine";
      Real Edc(unit="MW")"exergy destruction for compressor";
      Real Edst(unit="MW")"exergy destruction for steam turbine";
      Real Edp(unit="MW")"exergy destruction for pump";
      Real Edsg(unit="MW")"exergy destruction for heat recovery steam generator";
      Real E_lost(unit="MW")"total exergy lost and destruction";
      Real E_inc(unit="MW")"total exergy increased";
      String result;    /*To store the result*/
      //===============================
      
      //equation selection
      equation
        Ef32=mg*(h3-h2-T0*(s3-s2))/10^3;
        Ef51=mg*(h5-h1-T0*(s5-s1))/10^3;
        Ef89=mv*(h8-h9-T0*(s8-s9))/10^3;                    //Exergy balance equation
                                                            //Dividing by 10^3 to convert into MW
        Edt=mg*T0*(s4-s3-R/M*log(p4/p3))/10^3;
        Edc=mg*T0*(s2-s1-R/M*log(p2/p1))/10^3;
        Edst=mv*T0*(s8-s7)/10^3;
        Edp=mv*T0*(s6-s9)/10^3;
        Edsg=T0*(mg*(s5-s4)+mv*(s7-s6))/10^3;               //Exergy destruction rate equation
                                                            //Dividing by 10^3 to convert into MW
        E_lost=Ef51+Ef89+Edt+Edc+Edst+Edp+Edsg+Wgas+Wvap;
        E_inc=Ef32;
        
        
        if E_inc == E_lost then
          result = "exergy balance sheet satisfied";
        else
          result = "exergy balance sheet not satisfied";
        end if;
                
        Modelica.Utilities.Streams.print(result);

end Ex9_12_b;
//===============================

end Ex9_12;
