/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-9,Gas Power Systems
//Example 9_13 Page:347
//Title:Analyzing a Turbojet Engine
//===============================
model Ex9_13

    //parameter selection
    parameter Real ha(unit="Btu/lb")=102.7"specific enthalpy at state a";
    parameter Real pr1(unit="-")=1.051"relative pressure at state 1";     
                                                          /*From Table A-22E by interpolating 
                                                          h=119.2 Btu/lb. Appendix Pg:A-81*/
    parameter Real pra(unit="-")=0.6268"relative pressure at state a";    
                                                          /*From Table A-22E by interpolating 
                                                          h=102.7 Btu/lb. Appendix Pg:A-81*/
    parameter Real pa(unit="lbf/in2")=11.8"pressure at state a";
    parameter Real Va(unit="ft/s")=909.3"velocity at state a";
    parameter Real r(unit="-")=8"compressor ratio";
    parameter Real h2(unit="Btu/lb")=216.2"specific enthalpy at state 2"; 
                                                          /*From Table A-22E by interpolating 
                                                          pr=8.408. Appendix Pg:A-81*/
    
    parameter Real pr3(unit="-")=233.5"relative pressure at state 3";
    parameter Real h3(unit="Btu/lb")=546.54"specific enthalpy at state 3"; 
                                                          /*From Table A-22E at T=2150 R. 
                                                          Appendix Pg:A-81*/
    
        
    parameter Real pr4(unit="-")=113.8"relative pressure at state 4";    
                                                          /*From Table A-22E for 
                                                          h=449.5 Btu/lb. Appendix Pg:A-81*/
    parameter Real p5(unit="lbf/in2")=11.8"pressure at state 5";
    parameter Real h5(unit="Btu/lb")=265.8"specific enthalpy at state 5";    
                                                          /*From Table A-22E for pr=17.39. 
                                                          Appendix Pg:A-81*/
    //===============================
    
    //variable selection
    Real h1(unit="Btu/lb")"specific enthalpy at state 1";
    Real p1(unit="lbf/in2")"pressure at state 1";
    Real p2(unit="lbf/in2")"pressure at state 2";
    Real p3(unit="lbf/in2")"pressure at state 3";
    Real p4(unit="lbf/in2")"pressure at state 4";
    Real pr2(unit="-")"relative pressure at state 2";
    Real pr5(unit="-")"relative pressure at state 5";
    Real h4(unit="Btu/lb")"specific enthalpy at state 4";
    Real V5(unit="ft/s")"velocity at state 5";
    //===============================
    
    //equation selection
    equation
      V5=(2*(h4-h5)*32.2*778)^(1/2);
      h1=ha+Va^2/(2*32.2*778);                  //Reduced steady state mass and energy balance
                                                //Multiplying by 32.2 to convert into lb.ft/s^2.lbf
                                                //Multiplying by 778 to convert into ft.lbf
      h3-h4=h2-h1;
      p2=p3;
      p2/p1=r;                                  //Compression ratio
      p1=pr1/pra*pa;
      pr2=pr1*p2/p1;
      p4=p3*pr4/pr3;
      pr5=pr4*p5/p4;                            //From Eq. 9.21,Pg:320

end Ex9_13;
//===============================
