/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-9,Gas Power Systems
//Example 9_15 Page:364
//Title:Determining the Effect of Back Pressure: Converging–Diverging Nozzle
//===============================
package Ex9_15
  model Ex9_15_a
  //To find exit Mach number for isentropic flow with M = 0.7 at the throat
  
    //parameter selection
    parameter Real A2(unit = "in2") = 2.4 "exit area";
    parameter Real At(unit = "in2") = 1.0 "throat area";
    parameter Real M2a(unit = "-") = 0.24 "exit Mach number";
    parameter Real k(unit = "-") = 1.4 "specific heat ratio";
    parameter Real T0(unit = "R") = 500 "stagnation temperature";
    parameter Real p0(unit = "lbf/in2") = 100 "stagnation pressure";
    parameter Real Atr(unit = "-") = 1.09437 "throat area ratio";       /*From Table 9.2 for Mt=0.7. Pg:361*/
    final constant Real R(final unit = "ft.lbf/R.lb-mol") = 1545.33 "gas constant";
    final constant Real M(final unit = "lb/lb-mol") = 28.97 "molecular mass of air";
    //===============================
    
    //variable selection
    Real A2r(unit = "-") "exit area ratio";
    Real T2(unit = "R") "exit temperature";
    Real p2(unit = "lbf/in2") "exit pressure";
    Real V2(unit = "ft/s") "exit velocity";
    Real m(unit = "lb/s") "mass flow rate";
    //===============================
    
    //equation selection
    equation
      A2r = A2 / At * Atr;                          //Area ratio for sonic condition
      T2 / T0 = 0.988;
      p2 / p0 = 0.959;                              //From Table 9.2 for M2=0.24. Pg:361
      V2 = M2a * (k * R / M * T2 * 32.2) ^ (1 / 2); //From Eq. 9.37 with Mach number, Pg:352 
      m = p2 / (R / M * T2) * A2 * V2;              //Mass flow rate
  end Ex9_15_a;
  //===============================

  model Ex9_15_b
  //To find Mach number Isentropic flow with M = 1 at the throat and the diverging portion acting as a diffuser
  
    //parameter selection
    parameter Real A2(unit = "in2") = 2.4 "exit area";
    parameter Real At(unit = "in2") = 1.0 "throat area";
    parameter Real M2(unit = "-") = 0.26 "exit Mach number";      /*From Table 9.2 for area ratio =2.4. Pg:361*/
    parameter Real k(unit = "-") = 1.4 "specific heat ratio";
    parameter Real T0(unit = "R") = 500 "stagnation temperature";
    parameter Real p0(unit = "lbf/in2") = 100 "stagnation pressure";
    parameter Real Atr(unit = "-") = 1 "throat area ratio";       
    final constant Real R(final unit = "ft.lbf/R.lb-mol") = 1545.33 "gas constant";
    final constant Real M(final unit = "lb/lb-mol") = 28.97 "molecular mass of air";
    //===============================
    
    //variable selection
    Real A2r(unit = "-") "exit area ratio";
    Real T2(unit = "R") "exit temperature";
    Real p2(unit = "lbf/in2") "exit pressure";
    Real V2(unit = "ft/s") "exit velocity";
    Real m(unit = "lb/s") "mass flow rate";
    //===============================
    
    //equation selection
    equation
      A2r = A2 / At * Atr;//Area ratio for sonic condition
      T2 / T0 = 0.986;
      p2 / p0 = 0.953;                                //From Table 9.2 for M2=0.24. Pg:361
      V2 = M2 * (k * R / M * T2 * 32.2) ^ (1 / 2);    //From Eq. 9.37 with Mach number, Pg:352
      m = p2 / (R / M * T2) * A2 * V2;                //Mass flow rate

  end Ex9_15_b;
  //===============================

  model Ex9_15_c
  //To find Mach number Isentropic flow with M = 1 at the throat and the diverging portion acting as a nozzle
    
    //parameter selection
    parameter Real p0(unit = "lbf/in2") = 100 "stagnation pressure";
    //===============================
    
    //variable selection
    Real p2(unit = "lbf/in2") "exit pressure";
    //===============================
    
    //equation selection
    equation
      p2 / p0 = 0.0684;  //From Table 9.2 for M2=2.4
      
  //Mass flow rate is same as solution to Ex. 9.15(b)
  end Ex9_15_c;
  //===============================

  model Ex9_15_d
  //To find Mach number for Isentropic flow through the nozzle with a normal shock standing at the exit
    
    //parameter selection
    parameter Real Mx(unit="-")=2.4"Mach number of upstream";  
    parameter Real px(unit="lbf/in2")=6.84"pressure at the upstream";    
    parameter Real p0(unit = "lbf/in2") = 100 "stagnation pressure";
    //===============================
    
    //variable selection
    Real py(unit = "lbf/in2") "exit pressure";
    //===============================
    
    //equation selection
    equation
    py/px=6.5533;         //From Table 9.3 for M=0.52. Pg:364
    
  //Mass flow rate is same as solution to Ex. 9.15(b)
  end Ex9_15_d;
  //===============================

  model Ex9_15_e
  //To find Mach number for a normal shock stands in the diverging section
  
    //parameter selection
    parameter Real Ax(unit="in2")=1.0"area at throat for sonic flow";
    parameter Real A2(unit="in2")=2.4"exit area";
    parameter Real pox(unit="lbf/in2")=100"inlet pressure";
    parameter Real pyx(unit="-")=0.62812"ratio of stagnation pressures";       /*From Table 9.3 for Mx=2.2. Pg:364*/
    parameter Real p2y(unit="-")=0.88"pressure ratio of exit to downstream";   /*From Table 9.2 for M2=0.43. Pg:361*/
    //===============================
    
    //variable selection
    Real A2y(unit="-")"area ratio of exit to downstream";
    Real p2(unit="lbf/in2")"exit pressure";
    //===============================
    
    //equation selection
    equation
      A2y=A2/Ax*pyx;      //From Eq. 9.57 Pg:363
      p2=p2y*pyx*pox;     //Pressure ratio for sonic condition
      
  end Ex9_15_e;
  //===============================
end Ex9_15;
