/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-9,Gas Power Systems
//Example 9_2 Page:313
//Title:Analyzing the Diesel Cycle
//===============================
package Ex9_2
  model Ex9_2_a
  //To find the temperature and pressure at the end of each process
  
      //parameter selection
      parameter Real r(unit = "-") = 18 "compression ratio";
      parameter Real p1(unit = "MPa") = 0.1 "pressure at state 1";
      parameter Real T1(unit = "K") = 300 "teperature at state 1";
      parameter Real vr1(unit = "-") = 621.2 "specific relative volume at state 1"; 
                                                                    /*From Table A-22 at T=300 K. 
                                                                    Appendix Pg:A-39*/
                                                                    /*Interpolating with vr2=34.51 
                                                                    in Table A-22. Appendix Pg:A-40*/
      parameter Real vr3(unit = "-") =3.97 "specific relative volume at state 3";        
                                                                    /*From Table A-22 at T=1796.6 K. 
                                                                    Appendix Pg:A-40*/
      parameter Real rc(unit="-")=2"cut off ratio";     
      parameter Real T2a(unit = "K") = 880 "temperature a for state 2";
      parameter Real T2b(unit = "K") = 900 "temperature b for state 2";
      parameter Real vr2a(unit = "-") = 36.61 "specific relative volume a for state 2";
      parameter Real vr2b(unit = "-") = 34.31 "specific relative volume b for state 2";  
                                                                          /*From Table-22 at vr2=34.15 for 
                                                                          interpolating T. Appendix Pg:A-40*/  
      parameter Real T4a(unit = "K") = 880 "temperature a for state 4";
      parameter Real T4b(unit = "K") = 900 "temperature b for state 4";
      parameter Real vr4a(unit = "-") = 36.61 "specific relative volume a for state 4";
      parameter Real vr4b(unit = "-") = 34.31 "specific relative volume b for state 4";
                                                                          /*From Table-22 at vr4=35.73 for 
                                                                          interpolating T. Appendix Pg:A-40*/ 
      //===============================
      
      //variable selection
      Real vr2(unit = "-") "specific relative volume at state 2";
      Real vr4(unit = "-") "specific relative volume at state 4";
      Real T3(unit = "K") "temperature at state 3";
      Real p2(unit = "MPa") "pressure at state 2";
      Real p4(unit = "MPa") "pressure at state 4";
      Real T2(unit = "K") "temperature at state 2";
      Real T4(unit = "K") "temperature at state 4";
      //===============================
      
      //equation selection
      equation
        vr2 = vr1 / r;
        vr4 = vr3 * r/rc;            //From Eq. 9.4, Pg:308
        T3=rc*T2;
        p2 = p1 * (T2 / T1) * r;
        p4 = p1 * (T4 / T1);         //Ideal gas equation of state
        (T2 - T2a) / (T2b - T2a) = (vr2 - vr2a) / (vr2b - vr2a);
        (T4 - T4a) / (T4b - T4a) = (vr4 - vr4a) / (vr4b - vr4a);  //Interpolation
  end Ex9_2_a;

  //===============================

  model Ex9_2_b
  //To find thermal efficiency
  
      //parameter selection
      parameter Real u1(unit = "kJ/kg") = 214.07 "specific internal energy at state 1";
                                                                            /*From Table A-22 at T=300 K. 
                                                                            Appendix Pg:A-39*/
      parameter Real u4(unit = "kJ/kg") = 664.3 "specific internal energy at state 4";
                                                                            /*From Table A-22 at T=887.7 K. 
                                                                            Appendix Pg:A-40*/
      parameter Real h3(unit = "kJ/kg") = 1999.1 "specific enthalpy at state 3";
                                                                            /*From Table A-22 at T=1796.6 K. 
                                                                            Appendix Pg:A-40*/
      parameter Real h2(unit = "kJ/kg") = 930.98 "specific enthalpy at state 2";
                                                                            /*From Table A-22 at T=898.3 K. 
                                                                            Appendix Pg:A-40*/
      //===============================
      
      //variable selection
      Real n(unit = "-") "thermal efficiency";
      //===============================
      
      //equation selection
      equation
        n = 1 - (u4 - u1) / (h3 - h2);                //Thermal efficiency
  end Ex9_2_b;

  //===============================

  model Ex9_2_c
  //To find mean effective pressure
  
      //===============================
      extends Ex9_2_a;
      extends Ex9_2_b;
      //===============================
      
      //parameter selection
      final constant Real R(final unit="J/kmol.K")=8314"gas constant";
      final constant Real M(final unit="kg/kmol")=28.97"molecular mass of air"; /*From Table A-1. Appendix Pg:A-2*/
  
      //===============================
      
      //variable selection
      Real Wcycle_m(unit="kJ/kg")"net work per cycle per unit mass";
      Real v1(unit="m3/kg")"specific volume at state 1";
      Real mep(unit="MPa")"mean effective pressure";
      //===============================
      
      //equation selection
      equation
        v1=(R/M)*T1/(p1*10^6);                       //Ideal gas equation of state
                                                     //Multiplying by 10^6 to convert into Pa
        Wcycle_m=(h3-h2)-(u4-u1);                    //Net work per cycle
        mep=Wcycle_m/(v1*(1-(1/r)))*(10^3/10^6);     //Mean effective pressure
                                                     //Multiplying by 10^3 to convert into kJ
                                                     //Dividing by 10^6 to convert into MPa
  end Ex9_2_c;

  //===============================
end Ex9_2;
