/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-9,Gas Power Systems
//Example 9_3 Page:315
//Title:Analyzing the Dual Cycle
//===============================
package Ex9_3
  model Ex9_3_a
  //To find thermal efficiency
  
      //parameter selection
      parameter Real ratio_p(unit = "-") = 1.5 "pressure ratio";
      parameter Real ratio_v(unit = "-") = 1.2 "volume ratio";
      parameter Real r(unit = "-") = 18 "compression ratio";
      parameter Real T1(unit = "K") = 300 "temperature at state 1";
      parameter Real T2(unit = "K") = 898.3 "temperature at state 2";
      parameter Real u1(unit = "kJ/kg") = 214.07 "specific internal energy at state 1";
                                                                              /*From Table A-22 at T=300 K. 
                                                                              Appendix Pg:A-39*/
      parameter Real u2(unit = "kJ/kg") = 673.2 "specific internal energy at state 2";
                                                                              /*From Table A-22 at T=898.3 K. 
                                                                              Appendix Pg:A-39*/
      parameter Real h3(unit = "kJ/kg") = 1452.6 "specific enthalpy at state 3";
      parameter Real u3(unit = "kJ/kg") = 1065.8 "specific internal energy at state 3";
                                                                              /*From Table A-22 at T=1347.5 K. 
                                                                              Appendix Pg:A-40*/
      parameter Real h4(unit = "kJ/kg") = 1778.3 "specific enthalpy at state 4";
      parameter Real vr4(unit = "-") = 5.609 "specific relative volume at state 4";
                                                                              /*From Table A-22 at T=1617 K. 
                                                                              Appendix Pg:A-40*/
      parameter Real u5(unit = "kJ/kg") = 475.96 "specific internal energy at state 5";
                                                                              /*Interpolating in Table A-22 
                                                                              at vr=84.135. 
                                                                              Appendix Pg:A-39*/
      //===============================
      
      //variable selection
      Real T3(unit = "K") "temperature at state 3";
      Real T4(unit = "K") "temperature at state 4";
      Real V5_V4(unit = "-") "volume ratio V5/V4";
      Real vr5(unit = "-") "specific relative volume at state 5";
      Real n(unit = "-") "thermal efficiency";
      //===============================
      
      //equation selection
      equation
        T3 = ratio_p * T2;
        T4 = ratio_v * T3;                         //Reduced ideal gas equation of state
        V5_V4 = r / ratio_v;
        vr5 = vr4 * V5_V4;                         //From Eq. 9.4, Pg:308
        n = 1 - (u5 - u1) / (u3 - u2 + h4 - h3);   //Thermal efficiency
  end Ex9_3_a;
  //===============================

  model Ex9_3_b
  //To find mean effective pressure
  
      //===============================
      extends Ex9_3_a;
      //===============================
      
      //parameter selection
      parameter Real p1(unit="MPa")=0.1"pressure at state 1";
      final constant Real R(final unit="J/kmol.K")=8314"gas constant";
      final constant Real M(final unit="kg/kmol")=28.97"molecular mass of air"; 
                                                      /*From Table A-1. Appendix Pg:A-2*/
      //===============================
      
      //variable selection
      Real v1(unit="m3/kg")"specific volume at state 1";   
      Real mep(unit="MPa")"mean effective pressure";
      //===============================
      
      //equation selection
      equation
        v1=(R/M)*T1/(p1*10^6);                                     //Ideal gas equation of state
                                                                   //Multiplying by 10^6 to convert into Pa
        mep=((u3-u2)+(h4-h3)-(u5-u1))/(v1*(1-(1/r)))*(10^3/10^6);  //Mean effective pressure
                                                                   //Multiplying by 10^3 to convert into kJ
                                                                   //Dividing by 10^6 to convert into MPa
  end Ex9_3_b;
end Ex9_3;
