/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-9,Gas Power Systems
//Example 9_4 Page:320
//Title:Analyzing the Ideal Brayton Cycle
//===============================
package Ex9_4
  model Ex9_4_a
  //To find thermal efficiency
  
      //parameter selection
      parameter Real ratio_p(unit = "-") = 10 "pressure ratio";
      parameter Real h1(unit = "kJ/kg") = 300.19 "specific enthalpy at state 1";
      parameter Real pr1(unit = "-") = 1.386 "relative pressure at state 1";
                                                                    /*From Table A-22 at T=300 K. 
                                                                    Appendix Pg:A-39"*/
      parameter Real h2(unit = "kJ/kg") = 579.9 "specific enthapy at state 2";
                                                                    /*From Table A-22 at pr=13.86. 
                                                                    Appendix Pg:A-39"*/
      parameter Real h3(unit = "kJ/kg") = 1515.4 "specific enthalpy at state 3";
      parameter Real pr3(unit = "-") = 450.5 "relative pressure at state 3";
                                                                    /*From Table A-22 at T=1400 K. 
                                                                    Appendix Pg:A-40*/
      parameter Real h4(unit = "kJ/kg") = 808.5 "specific enthalpy at state 4";
                                                                    /*From Table A-22 at pr=45.05. 
                                                                    Appendix Pg:A-40*/
      //===============================
      
      //variable selection
      Real pr2(unit = "-") "relative pressure at state 2";
      Real pr4(unit = "-") "relative pressure at state 4";
      Real n(unit = "-") "thermal efficiency";
      //===============================
      
      //equation selection
    equation
      pr2 = ratio_p * pr1;
      pr4 = pr3 * (1 / ratio_p);                    //From Eq. 9.21,Pg:320
      n = (h3 - h4 - (h2 - h1)) / (h3 - h2);        //Thermal efficiency
  end Ex9_4_a;

  //===============================

  model Ex9_4_b
  //To find back work ratio
    
      //===============================
      extends Ex9_4_a;
      //===============================
      
      //variable selection
      Real bwr(unit = "-") "back work ratio";
      //===============================
      
      //equation selection
      equation
        bwr = (h2 - h1) / (h3 - h4);            //Back work ratio
  end Ex9_4_b;

  //===============================

  model Ex9_4_c
  //To find net power developed
  
      //===============================
      extends Ex9_4_a;
      //===============================
      
      //parameter selection
      parameter Real p1(unit="kPa")=100"pressure at state 1";
      parameter Real AV1(unit="m3/s")=5"volumetric flow rate";
      parameter Real T1(unit="K")=300"temperature at state 1";   
      final constant Real R(final unit="J/kmol.K")=8314"gas constant";
      final constant Real M(final unit="kg/kmol")=28.97"molecular mass of air"; 
                                                                  /*From Table A-1. Appendix Pg:A-2*/
      //===============================
      
      //variable selection
      Real v1(unit="m3/kg")"specific volume at state 1";
      Real m(unit="kg/s")"mass flow rate";
      Real Wcycle(unit="kW")"net power developed";
      //===============================
      
      //equation selection
      equation
        Wcycle=m*((h3-h4)-(h2-h1));    //Net power developed
        m=AV1/v1;                      //Continuity equation
        v1=R/M*T1/(p1*10^3);           //Ideal gas equation of state
                                       //Multiplying by 10^3 to convert into Pa
  end Ex9_4_c;

  //===============================
end Ex9_4;
