/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-9,Gas Power Systems
//Example 9_7 Page:328
//Title:Evaluating Thermal Efficiency of a Brayton Cycle with Regeneration
//===============================
package Ex9_7
  model Ex9_7_a
  //To find thermal efficiency
  
      //parameter selection
      parameter Real h1(unit = "kJ/kg") = 300.19 "specific enthalpy at state 1";    
                                                                    /*From Table A-22 at T=300 K. 
                                                                    Appendix Pg:A-39"*/
      parameter Real h2(unit = "kJ/kg") = 579.9 "specific enthapy at state 2";
                                                                    /*From Table A-22 at pr=13.86. 
                                                                    Appendix Pg:A-39"*/
      parameter Real h3(unit = "kJ/kg") = 1515.4 "specific enthalpy at state 3";
                                                                    /*From Table A-22 at T=1400 K. 
                                                                    Appendix Pg:A-40*/
      parameter Real h4(unit = "kJ/kg") = 808.5 "specific enthalpy at state 4";
                                                                    /*From Table A-22 at pr=45.05. 
                                                                    Appendix Pg:A-40*/
                                                                    /*From Example 9.4, Pg:320*/
      parameter Real nreg(unit="-")=0.80"regenerator effectiveness";
      //===============================
      
      //variable selection
      Real hx(unit="kJ/kg")"specific enthalpy at state x";
      Real n(unit="-")"thermal efficiency";
      //===============================
      
      //equation selection
      equation
        hx=nreg*(h4-h2)+h2;              //Regenerator effectiveness
        n=((h3-h4)-(h2-h1))/(h3-hx);     //Thermal efficiency
  
  end Ex9_7_a;
  //===============================
end Ex9_7;
