/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-9,Gas Power Systems
//Example 9_8 Page:330
//Title:Determining Thermal Efficiency of a Brayton Cycle with Reheat and Regeneration
//===============================
model Ex9_8
//To find thermal efficiency

    //parameter selection
    parameter Real pa(unit="kPa")=300"pressure at state a";
    parameter Real p3(unit="kPa")=1000"pressure at state 3";
    parameter Real pb(unit="kPa")=300"pressure at state b";
    parameter Real p4(unit="kPa")=100"pressure at state 4";
    parameter Real h1(unit = "kJ/kg") = 300.19 "specific enthalpy at state 1";    
                                                                  /*From Table A-22 at T=300 K. 
                                                                  Appendix Pg:A-39"*/
    parameter Real h2(unit = "kJ/kg") = 579.9 "specific enthapy at state 2";
                                                                  /*From Table A-22 at pr=13.86. 
                                                                  Appendix Pg:A-39"*/
    parameter Real h3(unit = "kJ/kg") = 1515.4 "specific enthalpy at state 3";
    parameter Real pr3(unit = "-") = 450.5 "relative pressure at state 3";    
                                                                  /*From Table A-22 at T=1400 K. 
                                                                  Appendix Pg:A-40*/


    parameter Real h4(unit = "kJ/kg") = 1127.6 "specific enthalpy at state 4";
                                                                  /*From Table A-22 at pr=150.17. 
                                                                  Appendix Pg:A-40*/
                                                                  /*From Example 9.4, Pg:320*/    
                                                                     
    parameter Real ha(unit="kJ/kg")=1095.9"specific enthalpy at state a";  
                                                                  /*Interpolating in Table A-22 
                                                                  at pr=135.15. Appendix Pg:A-*/
    //===============================
    
    
    //variable selection
    Real pra(unit="-")"relative pressure at state a";
    Real prb(unit="-")"relative pressure at state b";
    Real pr4(unit="-")"relative pressure at state 4";
    Real hx(unit="kJ/kg")"specific enthalpy at state x";
    Real hb(unit="kJ/kg")"specific enthalpy at state b";
    Real n(unit="-")"thermal efficiency";
    //===============================
    
    //equation selection
    equation
      prb=pr3;
      hb=h3;
      hx=h4;
      pra=pr3*pa/p3;
      pr4=prb*p4/pb;                                    //From Eq. 9.21,Pg:320
      n=((h3-ha)+(hb-h4)-(h2-h1))/((h3-hx)+(hb-ha));    //Thermal efficiency

end Ex9_8;
//===============================
