/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-9,Gas Power Systems
//Example 9_9 Page:333
//Title:Evaluating a Two-Stage Compressor with Intercooling
//===============================
package Ex9_9
  model Ex9_9_a
    //To find temperature at the exit of second compressor stage
    
    //parameter selection
    parameter Real p2(unit = "kPa") = 1000 "pressure at state 2";
    parameter Real pd(unit = "kPa") = 300 "pressure at state d";
    parameter Real prd(unit = "-") = 1.386 "relative pressure at state d";
                                                          /*From Table A-22 at T=300 K. 
                                                          Appendix Pg:A-39*/
    parameter Real T2a(unit = "K") = 420 "temperature a for state 2";
    parameter Real T2b(unit = "K") = 430 "temperature b for state 2";
    parameter Real pr2a(unit = "-") = 4.522 "relative pressure a for state 2";
    parameter Real pr2b(unit = "-") = 4.915 "relative pressure b for state 2";
                                                          /*From Table-22 at pr2=4.62 for 
                                                          interpolating T. Appendix Pg:A-39*/
    //===============================
    
    //variable selection
    Real pr2(unit = "-") "relative pressure at state 2";
    Real T2(unit = "K") "temperature at state 2";
    //===============================
    
    //equation selection
    equation
    pr2 = prd * p2 / pd;                                      //From Eq. 9.21,Pg:320
    (T2 - T2a) / (T2b - T2a) = (pr2 - pr2a) / (pr2b - pr2a);  //Interpolation
  end Ex9_9_a;

  //===============================

  model Ex9_9_b
    //To find total compressor work input per unit of mass flow
    
    //===============================
    extends Ex9_9_a;
    //===============================
    
    //parameter selection
    parameter Real p1(unit = "kPa") = 100 "pressure at state 1";
    parameter Real pc(unit = "kPa") = 300 "pressure at state c";
    parameter Real h1(unit = "kJ/kg") = 300.19 "specific enthalpy at state 1";
                                                              /*From Table A-22 at T=300 K. 
                                                              Appendix Pg:A-39*/
    parameter Real h2(unit = "kJ/kg") = 423.8 "specific enthalpy at state 2";
    parameter Real hca(unit = "kJ/kg") = 411.12 "specific enthalpy a for state c";
    parameter Real hcb(unit = "kJ/kg") = 421.26 "specific enthalpy b for state c";
    parameter Real prca(unit = "-") = 4.153 "relative pressure a for state c";
    parameter Real prcb(unit = "-") = 4.522 "relative pressure b for state c";
                                                              /*From Table-22 at prc=4.158 for 
                                                              interpolating T. Appendix Pg:A-40*/
    //===============================
    //variable selection
    Real hd(unit = "kJ/kg") "specific enthalpy at state d";
    Real Wc_m(unit = "kJ/kg") "compressor work input per unit mass";
    Real prc(unit = "-") "relative pressure at state c";
    Real pr1(unit = "-") "relative pressure at state 1";
    Real hc(unit = "kJ/kg") "specific enthalpy at state c";  
    //===============================
    
    //equation selection
  equation
    hd = h1;
    prd = pr1;
    Wc_m = hc - h1 + h2 - hd;                           //Reduced steady state mass and energy balance
    prc = pr1 * pc / p1;                                //From Eq. 9.21,Pg:320
  (hc - hca) / (hcb - hca) = (prc - prca) / (prcb - prca);//Interpolation
  end Ex9_9_b;

  //===============================

  model Ex9_9_c
    //For single stage isentropic compression
    
    //===============================
    extends Ex9_9_a;
    extends Ex9_9_b;
    //===============================
    
    //parameter selection
    parameter Real T3a(unit = "K") = 570 "temperature a for state 2";
    parameter Real T3b(unit = "K") = 580 "temperature b for state 2";
    parameter Real h3a(unit = "kJ/kg") = 575.59 "specific enthalpy a for state 3";
    parameter Real h3b(unit = "kJ/kg") = 586.04 "specific enthalpy b for state 3";
    parameter Real pr3a(unit = "-") = 13.50 "relative pressure a for state 3";
    parameter Real pr3b(unit = "-") = 14.38 "relative pressure b for state 3";
                                                             /*From Table-22 at pr3=13.86 for 
                                                             interpolating T. Appendix Pg:A-40*/
    //===============================
    
    //variable selection
    Real Wc_mc(unit = "kJ/kg") "work input for a single stage of compression";
    Real p3(unit = "kPa") "pressure at state 3";
    Real pr3(unit = "-") "relative pressure at state 3";
    Real h3(unit = "kJ/kg") "specific enthalpy at state 3";
    Real T3(unit = "K") "temperature at state 3";
    //===============================
    
    //equation selection
    equation
    p3 = p2;
    Wc_mc = h3 - h1;
    pr3 = pr1 * p3 / p1;                                    //From Eq. 9.21,Pg:320
    (T3 - T3a) / (T3b - T3a) = (pr3 - pr3a) / (pr3b - pr3a);
    (h3 - h3a) / (h3b - h3a) = (pr3 - pr3a) / (pr3b - pr3a);//Interpolation
  end Ex9_9_c;

  //===============================
end Ex9_9;
