/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-10,Refrigeration and Heat Pump Systems
//Example 10_2 Page:376
//Title:Considering the Effect of Irreversible Heat Transfer on Performance
//===============================
package Ex10_2
  model Ex10_2_a
  //To find the compressor power
    
        //parameter selection
        parameter Real m(unit = "kg/s") = 0.08 "mass flow rate";
        parameter Real h1(unit = "kJ/kg") = 241.35 "specific enthalpy at state 1";    
                                                              /*From Table A-10 interpolating at T=-10 C 
                                                              for saturated vapour. 
                                                              Appendix Pg:A-19*/
        parameter Real h2s(unit = "kJ/kg") = 272.39 "specific enthalpy at state 2s";    
                                                              /*From Table A-12 interpolating 
                                                              at T=299 K and p=9 bar. 
                                                              Appendix Pg:A-22*/
        //===============================
        
        //variable selection
        Real Wc(unit = "kW") "compressor work input";
        //===============================
        
        //equation selection
        equation
          Wc = m * (h2s - h1);     //From Eq. 10.4, Pg:372

  end Ex10_2_a;
  //===============================

  model Ex10_2_b
  //To find refrigeration capacity
      
      //===============================
      extends Ex10_2_a;
      //===============================
      
      //parameter selection
      parameter Real h3(unit="kJ/kg")=99.56"specific enthalpy at state 3";    
                                                           /*From Table A-11 at p=9 bar for 
                                                           saturated liquid. Appendix Pg:A-20*/
      //===============================
      
      //variable selection
      Real h4(unit="kJ/kg")"specific enthalpy at state 4";
      Real Qin(unit="ton")"refrigeration capacity";
      //===============================
      
      //equation selection
      equation
        h3=h4;
        Qin=m*60*(h1-h4)/211;     //From Eq. 10.3, Pg:372
                                  //Multiplying by 60 to convert into second
                                  //Dividing by 211 to convert into ton
  end Ex10_2_b;
  //===============================

  model Ex10_2_c
  //To find coefficient of performance
  
      //===============================
      extends Ex10_2_a;
      extends Ex10_2_b;
      //===============================
      
      //variable seection
      Real b(unit="-")"coefficient of performance";
      //===============================
      
      //equation selection
      equation
        b=(h1-h4)/(h2s-h1);       //Coefficient of performance

  end Ex10_2_c;
  //===============================
end Ex10_2;
