/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-10,Refrigeration and Heat Pump Systems
//Example 10_3 Page:377
//Title:Analyzing an Actual Vapor-Compression Refrigeration Cycle
//===============================
package Ex10_3
  model Ex10_3_a
  //To find the compressor power
  
      //parameter selection
      parameter Real m(unit = "kg/s") = 0.08 "mass flow rate";
      parameter Real h1(unit = "kJ/kg") = 241.35 "specific enthalpy at state 1";
      parameter Real s1(unit = "kJ/kg.K") = 0.9253 "specific entropy at state 1";
                                                                    /*From Table A-10 interpolating 
                                                                    at T=-10 C for saturated vapour.                                                              
                                                                    Appendix Pg:A-19*/
      parameter Real h2s(unit = "kJ/kg") = 272.39 "specific enthalpy at state 2s";
      parameter Real s2(unit = "kJ/kg.K") = 0.9497 "specific entropy at state 2";
                                                                    /*From Table A-12 interpolating 
                                                                    at T=299 K and p=9 bar. 
                                                                    Appendix Pg:A-22*/
      parameter Real h3(unit = "kJ/kg") = 91.49 "specific enthalpy at state 3";
      parameter Real s3(unit = "kJ/kg.K") = 0.3396 "specific entropy at state 3";
                                                                    /*From Table A-10 at T=30 C 
                                                                    for saturated liquid. 
                                                                    Appendix Pg:A-19*/
      parameter Real hf4(unit = "kJ/kg") = 36.97 "specific enthalpy of saturated liquid at state 4";
      parameter Real hfg4(unit = "kJ/kg") = 204.39 "specific enthalpy difference at state 4";
      parameter Real sf4(unit = "kJ/kg.K") = 0.1486 "specific entropy of saturated liquid at state 4";
      parameter Real sg4(unit = "kJ/kg.K") = 0.9253 "specific entroopy of saturated vapour at state 4";
                                                                    /*From Table A-10 interpolating at 
                                                                    T=-10 C. Appendix Pg:A-19*/
      parameter Real nc(unit = "-") = 0.80 "isentropi efficiency";
      
      //===============================
      
      //variable selection
      Real h2(unit = "kJ/kg") "specific enthalpy at state 2";
      Real x4(unit = "-") "quality of liquid-vapour mixture at state 4";
      Real s4(unit = "kJ/kg.K") "specific entropy at state 4";
      Real Wc(unit = "kW") "compressor power";
      Real h4(unit = "kJ/kg") "specific enthalpy at state 4";
      //===============================
      
      //equation selection
      equation
        h3 = h4;
        nc = (h2s - h1) / (h2 - h1);        //Isentropic compressor efficiency
        x4 = (h4 - hf4) / hfg4;             //Quality of liquid-vapour mixture
        s4 = sf4 + x4 * (sg4 - sf4);        //Specific entropy of liquid-vapour mixture
        Wc = m * (h2 - h1);                 //From Eq. 10.4, Pg:372
  end Ex10_3_a;
  //===============================
  
  model Ex10_3_b
  //To find refrigeration capacity
  
      //===============================
      extends Ex10_3_a;
      //===============================
      
      //variable selection
      Real Qin(unit="ton")"refrigeration capacity";
      //===============================
      
      //equation selection
      equation
          Qin=m*60*(h1-h4)/211;       //From Eq. 10.3, Pg:372
                                      //Multiplying by 60 to convert into second
                                      //Dividing by 211 to convert into ton
  end Ex10_3_b;
  //===============================
  
  model Ex10_3_c
  //To find coefficient of performance
  
      //===============================
      extends Ex10_3_a;
      extends Ex10_3_b;
      //===============================
      
      //variable seection
      Real b(unit="-")"coefficient of performance";
      //===============================
      
      //equation selection
      equation
        b=(h1-h4)/(h2-h1);       //Coefficient of performance

  end Ex10_3_c;
  //===============================

  model Ex10_3_d
  //To find the exergy destruction rate
  
      //===============================
      extends Ex10_3_a;
      extends Ex10_3_b;
      //===============================
      
      //parameter selection
      parameter Real T0(unit="K")=299"temperature of the dead state";
      //===============================
      
      //variable selection
      Real Edc(unit="kW")"exergy destruction rate of compressor";
      Real Edvalve(unit="kW")"exergy destruction rate of valve";
      //===============================
      
      //equation selection
      equation
        Edc=m*T0*(s2-s1);
        Edvalve=m*T0*(s4-s3);     //From exergy rate balance
      
  end Ex10_3_d;
  //===============================
end Ex10_3;
