/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-10,Refrigeration and Heat Pump Systems
//Example 10_5 Page:391
//Title:Analyzing an Ideal Brayton Refrigeration Cycle
//===============================
package Ex10_5
  model Ex10_5_a
  //To find net power input
        
      //parameter selection
      parameter Real AV1(unit = "ft3/s") = 50 "volumetric flow rate";
      parameter Real h1(unit = "Btu/lb") = 114.69 "specific enthalpy at state 1";
      parameter Real pr1(unit = "-") = 0.9182 "relative pressure at state 1";
                                                              /*From Table A-22E at T=480 R. 
                                                              Appendix Pg:A-89*/
      parameter Real p1(unit = "atm") = 1 "pressure at state 1";
      parameter Real p3(unit = "atm") = 3 "pressure at state 3";
      parameter Real h2s(unit = "Btu/lb") = 157.1 "specific enthalpy at state 2s";
                                                              /*From table A-22E interpolating 
                                                              for pr=2.755. Appendix Pg:A-89*/
      parameter Real h3(unit = "Btu/lb") = 129.06 "specific enthalpy at state 3";
      parameter Real pr3(unit = "-") = 1.3860 "relative pressure at state 3";
                                                              /*From Table A-22E at T=540 R. 
                                                              Appendix Pg:A-89*/
      parameter Real h4s(unit = "Btu/lb") = 94.1 "specific enthalpy at state 4s";
                                                              /*From table A-22E interpolating 
                                                              for pr=0.462. Appendix Pg:A-89*/
      parameter Real p4(unit = "atm") = 1 "pressure at state 4";
      parameter Real T1(unit = "R") = 480 "temperature at state 1";
      final constant Real R(final unit = "ft.lbf/R.lb-mol") = 1545.33 "gas constant";
      final constant Real M(final unit = "lb/lb-mol") = 28.97 "molecular mass of air";
      //===============================
      
      //variable selection
      Real Wcycle(unit = "Btu/min") "net power input";
      Real m(unit = "lb/min") "mass flow rate";
      //===============================
      
      //equation selection
      equation
        Wcycle = m * (h2s - h1 - (h3 - h4s));             //From Eq. 10.4, Pg:372
        m = AV1 * 60 * 14.7 * 144 / (R / M * T1);         //Mass flow rate
                                                          //Multiplying by 60 to convert into seconds
                                                          //Multiplying by 14.7 to convert into lbf/in^2
                                                          //Multiplying by 144 to convert into in^2
  end Ex10_5_a;
  //===============================

  model Ex10_5_b
  //To find refrigeration capacity
  
      //===============================
      extends Ex10_5_a;
      //===============================
      
      //variable selection
      Real Qin(unit="Btu/min")"refrigeration capacity";
      //===============================
      
      //equation selection
      equation
        Qin=m*(h1-h4s);       //From Eq. 10.3, Pg:372
  
  end Ex10_5_b;
  //===============================

  model Ex10_5_c
  //To find coefficient of performance
  
      //===============================
      extends Ex10_5_a;
      extends Ex10_5_b;
      //===============================
      
      //variable selection
      Real b(unit="-")"coefficient of performance";
      //===============================
      
      //equation selection
      equation
        b=Qin/Wcycle;         //Coefficient of performance
  
  end Ex10_5_c;
  //===============================
end Ex10_5;
