/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-10,Refrigeration and Heat Pump Systems
//Example 10_6 Page:393
//Title:Evaluating Performance of a Brayton Refrigeration Cycle with Irreversibilities
//===============================
package Ex10_6
  model Ex10_6_a
  //To find net power input
  
      //parameter selection
      parameter Real Wc_ms(unit = "Btu/lb") = 42.41 "work per unit mass for the isentropic compression";
      parameter Real Wt_ms(unit = "Btu/lb") = 34.96 "turbine power output per unit mass";
                                                                  /*From solution to Example 10.5. Pg:391*/
      parameter Real m(unit = "lb/min") = 248 "mass flow rate";
      parameter Real nc(unit = "-") = 0.80 "isentropic compressor efficiency";
      parameter Real nt(unit = "-") = 0.80 "isentropic turbine efficiency";
      //===============================
      
      //variable selection
      Real Wc(unit = "Btu/min") "power input to compressor";
      Real Wt(unit = "Btu/min") "power output of the turbine";
      Real Wcycle(unit = "Btu/min") "net power input";
      //===============================
      
      //equation selection
      equation
        Wc = m * Wc_ms / nc;
        Wt = m * nt * Wt_ms;                    //Power with isentropic efficiency
        Wcycle = Wc - Wt;
  end Ex10_6_a;
  //===============================

  model Ex10_6_b
  //To find refrigeration capacity
  
      //===============================
      extends Ex10_6_a;
      //===============================
      
      //parameter selection
      parameter Real h1(unit = "Btu/lb") = 114.69 "specific enthalpy at state 1";
                                                                  /*From Table A-22E at T=480 R. 
                                                                  Appendix Pg:A-89*/
      parameter Real h3(unit = "Btu/lb") = 129.06 "specific enthalpy at state 3";
                                                                  /*From Table A-22E at T=540 R. 
                                                                  Appendix Pg:A-89*/
      //===============================
      
      //variable selection
      Real h4(unit="Btu/lb")"specific enthalpy ata state 4";
      Real Qin(unit="Btu/min")"refrigeration capacity";
      //===============================
      
      //equation selection
      equation
        Wt=m*(h3-h4);              //From Eq. 10.4, Pg:372
        Qin=m*(h1-h4);             //From Eq. 10.3, Pg:372
  end Ex10_6_b;
  //===============================

  model Ex10_6_c
  //To find coefficient of performance
  
      //===============================
      extends Ex10_6_a;
      extends Ex10_6_b;
      //===============================
      
      //variable selection
      Real b(unit="-")"coefficient of performance";
      //===============================
      
      //equation selection
      equation
        b=Qin/Wcycle;         //Coefficient of performance

  end Ex10_6_c;
  //===============================
end Ex10_6;
