/*Michael J. Moran, Howard N. Shapiro, Daisie D. Boettner,Margaret B. Bailey,Fundamentals of Engineering Thermodynamics,9th Edition,John Wiley & Sons, Inc.,2018*/
//Chapter-11,Thermodynamic Relations
//Example 11_1 Page:403
//Title:Comparing Equations of State
//===============================
package Ex11_1
  model Ex11_1_a
  //To find pressure using compressibilty chart
  
      //===============================
      extends Modelica.Constants;
      //===============================
      
      //parameter selection
      parameter Real D(unit = "m") = 0.2 "diameter of the cylinder";
      parameter Real L(unit = "m") = 1.0 "length of the cylinder";
      parameter Real m(unit = "kg") = 4.0 "mass of carbon monoxide gas";
      parameter Real T(unit = "C") = -50 "temperature of the gas";
      parameter Real Z(unit = "-") = 0.9 "compressibilty factor";
                                                          /*From Fig A-2 for TR=1.68 
                                                          and vR=0.696. Appendix Pg:A-98*/
      parameter Real pc(unit = "bar") = 35 "critical pressure";
      parameter Real Tc(unit = "K") = 133 "critical temperature";
                                                          /*From Table A-1 for CO. 
                                                          Appendix Pg:A-2*/
      final constant Real R(final unit = "J/kmol.K") = 8314 "gas constant";
      final constant Real M(final unit = "kg/kmol") = 28.01 "molecular mass of CO";
                                                          /*From Table A-1. Appendix Pg:A-2*/
      //===============================
      
      //variable selection
      Real V(unit = "m3") "volume of the cylinder";
      Real v(unit = "m3/kmol") "molar specific volume";
      Real Tr(unit = "-") "reduced temperature";
      Real vR(unit = "-") "pseudoreduced specific volume";
      Real p(unit = "bar") "pressure exerted";
      //===============================
      
      //equation selection
      equation
        V = pi * D ^ 2 * L / 4;                         //Volume of cylinder
        v = M * (V / m);                                //Molar specific volume
        Tr = (T + 273.15) / Tc;                         //Reduced temperature
                                                        //Adding 273.15 to convert in Kelvin scale
        vR = v * pc * 10 ^ 5 / (R * Tc);                //Pseudoreduced specific volume
                                                        //Multiplying by 10^5 to convert into Pa
        p = Z * R * (T + 273.15) / v * (1 / 10 ^ 5);
                                                        //Pressure equation with compressibility factor
                                                        //Adding 273.15 to convert in Kelvin scale
                                                        //Dividing by 10^5 to convert into bar
    end Ex11_1_a;

  //===============================

  model Ex11_1_b
  //To find pressure from ideal gas equation of state
  
      //===============================
      extends Ex11_1_a;
      //===============================
      
      //variable selection
      Real pid(unit = "bar") "pressure exerted";
      //===============================
      
      //equation selection
      equation
        pid = R * (T + 273.15) / v * (1 / 10 ^ 5);       //Ideal gas equation of state
                                                        //Adding 273.15 to convert in Kelvin scale
                                                        //Dividing by 10^5 to convert into bar

  end Ex11_1_b;

  //===============================

  model Ex11_1_c
  //To find pressure by van der Waals equation of state
  
      //===============================
      extends Ex11_1_a;
      //===============================
      
      //parameter selection
      parameter Real a(unit = "m6/kmol2") = 1.474 "van der Waals constant";
      parameter Real b(unit = "m3/kmol") = 0.0395 "van der Waals constant";
                                                        /*From Table A-24 for CO. Appendix Pg:A-45*/
      //===============================
      
      //variable selection
      Real pv(unit = "bar") "pressure exerted";
      //===============================
      
      //equation selection
      equation
        pv = R * (T + 273.15) / (v - b) * (1 / 10 ^ 5) - a / v ^ 2;   //Van der Waals equation of state
                                                                      //Adding 273.15 to convert in Kelvin scale
                                                                      //Dividing by 10^5 to convert into bar
  end Ex11_1_c;

  //===============================

  model Ex11_1_d
  //To find pressure using Redlich-Kwong equation of state
  
      //===============================
      extends Ex11_1_a;
      //===============================
      
      //parameter selection
      parameter Real a(unit = "m6.K(1/2)/kmol2") = 17.22 "Redlich-Kwong constant";
      parameter Real b(unit = "m3/kmol") = 0.02737 "Redlich-Kwong constant";
                                                          /*From Table A-24 for CO. 
                                                          Appendix Pg:A-45*/
      //===============================
      
      //variable selection
      Real pr(unit = "bar") "pressure exerted";
      //===============================
      
      //equation selection
      equation
       pr = R * (T + 273.15) / (v - b) * (1 / 10 ^ 5) - a / (v * (v + b) * (T + 273.15) ^ 0.5);
                                                                  //Redlich-Kwong equation of state
                                                                  //Adding 273.15 to convert in Kelvin scale
                                                                  //Dividing by 10^5 to convert into bar
  end Ex11_1_d;

  //===============================
end Ex11_1;
